package com.yeejoin.equipmanage.service.impl;


import java.util.List;

import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.yeejoin.equipmanage.common.entity.TopographyNodeDetail;
import com.yeejoin.equipmanage.common.entity.dto.TopographyNodeDetailDTO;
import com.yeejoin.equipmanage.mapper.TopographyNodeDetailMapper;


/**
 * 
 * <pre>
 * 节点详情 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: TopographyNodeDetailService.java, v 0.1 2021年10月14日 下午4:15:16 gwb Exp $
 */
@Component
public class TopographyNodeDetailService extends BaseService<TopographyNodeDetailDTO,TopographyNodeDetail,TopographyNodeDetailMapper> {


	/**
	 * 根据id查询节点详情
	 */
	public TopographyNodeDetailDTO queryByNodeid(String nodeid)
	{
		return this.queryModelByParams(nodeid);
	}

	
	public List<TopographyNodeDetailDTO> queryByEqpId(Long eqpId)
	{
		return this.queryForList("", false, eqpId);
	}

}
