package com.yeejoin.amos.fas.business.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yeejoin.amos.fas.business.bo.FireEquipmentBo;
import com.yeejoin.amos.fas.business.dao.mapper.EquipmentSpecificIndexMapper;
import com.yeejoin.amos.fas.business.dao.mapper.FireEquipMapper;
import com.yeejoin.amos.fas.business.dao.mapper.ImpEquipMapper;
import com.yeejoin.amos.fas.business.feign.IEquipManageFeign;
import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.service.intfc.IFireEquipService;
import com.yeejoin.amos.fas.business.util.FireEquipmentType;
import com.yeejoin.amos.fas.business.vo.EquipmentSpecificIndexVo;
import com.yeejoin.amos.fas.business.vo.FireStationVo;
import com.yeejoin.amos.fas.common.enums.EquipClassifyEnum;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.response.CommonPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("fireEquipService")
public class FireEquipServiceImpl implements IFireEquipService {

    /**
     * 液位
     */
    private final static String NAME_KEY = "WaterLevel";

    @Autowired
    FireEquipMapper fireEquipMapper;

    @Autowired
    ImpEquipMapper impEquipMapper;

    @Autowired
    EquipmentSpecificIndexMapper equipmentSpecificIndexMapper;

    @Autowired
    private IEquipManageFeign equipManageFeign;

    public String[] delete(String[] idArray) throws Exception {
//        for (String id : idArray) {
//            Optional<FireEquipment> fireEquipment1 = iFireEquipmentDao.findById(Long.parseLong(id));
//            FireEquipment fireEquipment = null;
//            if (fireEquipment1.isPresent()) {
//                fireEquipment = fireEquipment1.get();
//            }
//
//            if (fireEquipment != null) {
//                this.iFireEquipmentDao.deleteById(Long.parseLong(id));
//            } else {
//                throw new Exception("找不到指定的对象:" + id);
//            }
//        }
        return idArray;
    }


    @Override
    public Page<HashMap<String, Object>> queryFireEquip(CommonPageInfoParam param) {
        long total = fireEquipMapper.countPageData(param);
        List<HashMap<String, Object>> content = fireEquipMapper.getFireEquipPage(param);
        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, param, total);
        return result;
    }

    @Override
    public Page<HashMap<String, Object>> queryFireEquipByProId(CommonPageInfoParam param) {
        long total = fireEquipMapper.countFireEquipByEquipIdPageData(param);
        List<HashMap<String, Object>> content = fireEquipMapper.getFFireEquipByEquipIdPage(param);
        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, param, total);
        return result;
    }

    @Override
    public List<String> findFireEquipArea() {
        return null;
//        return iFireEquipmentDao.findFireEquipArea();
    }


    //查询 消防设备历史数据
    public Page queryForFireEquipmentHistory(String fireEquipmentName,
                                             String equipmentName,
                                             String startTime,
                                             String endTime,
                                             String buildId,
                                             CommonPageable commonPageable) {

        long total = fireEquipMapper.queryForFireEquipmentHistoryCount(fireEquipmentName, equipmentName,
                startTime,
                endTime,
                buildId);

        List<Map> content = fireEquipMapper.queryForFireEquipmentHistory(fireEquipmentName,
                equipmentName,
                startTime,
                endTime,
                commonPageable.getOffset(),
                commonPageable.getPageSize(),
                buildId);
        Page result = new CommonPage(content, commonPageable, total);
        return result;
    }


    public Page queryForEquipmentList(String name, String code, String equipClassify, CommonPageable commonPageable, String bindStation) {
        long total = fireEquipMapper.queryForEquipmentPageCount(name, code, equipClassify, bindStation);
        List<Map> content = this.fireEquipMapper.queryForEquipmentPage(name, code, equipClassify, commonPageable.getOffset(), commonPageable.getPageSize(), bindStation);
        Page result = new CommonPage(content, commonPageable, total);
        return result;
    }


    /**
     * 查询设备信息明细
     *
     * @param type
     * @param id
     * @return
     * @throws Exception
     */
    public Object queryForDetail(String type, Long id) throws Exception {

        Object returnEntity = null;

        FireEquipmentType fireEquipmentType = FireEquipmentType.valueOf(type);
        switch (fireEquipmentType) {
            case pool:
                Object obj = equipManageFeign.findByInstanceId(id).get("result");
                if (obj != null) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    FireStationVo fireStationVo = objectMapper.convertValue(obj, FireStationVo.class);
                    fireStationVo.setType("2");
                    List<Map> equipDetails = this.fireEquipMapper.queryStorageEquips(fireStationVo.getRiskSourceId());
                    fireStationVo.setFireEquipmentInfo(equipDetails);
                    // 获取水池实时液位
                    List<Object> equipDetailIdList = new ArrayList<>();
                    if (equipDetails != null && !equipDetails.isEmpty()) {
                        equipDetails.stream().forEach(map -> equipDetailIdList.add(map.get("id")));
                        List<EquipmentSpecificIndexVo> specificIndexVos = equipmentSpecificIndexMapper.findByDetailIdInAndNameKey(equipDetailIdList, NAME_KEY);
                        if (specificIndexVos != null && !specificIndexVos.isEmpty()) {
                            fireStationVo.setLevel(specificIndexVos.get(0).getValue().concat(" ").concat(specificIndexVos.get(0).getEquipmentIndexUnitName()));
                        }
                    }
                    returnEntity = fireStationVo;
                }
                break;
            case fireFoamRoom:
                Object obj1 = equipManageFeign.findByInstanceId(id).get("result");
                if (obj1 != null) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    FireStationVo fireStationVo = objectMapper.convertValue(obj1, FireStationVo.class);
                    fireStationVo.setType("2");
                    List<Map> equipDetails = this.fireEquipMapper.queryStorageEquips(fireStationVo.getRiskSourceId());
                    fireStationVo.setFireEquipmentInfo(equipDetails);
                    returnEntity = fireStationVo;
                }
            case fireChamber:
                Object obj2 = equipManageFeign.findByInstanceId(id).get("result");
                if (obj2 != null) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    FireStationVo fireStationVo = objectMapper.convertValue(obj2, FireStationVo.class);
                    fireStationVo.setType("1");
                    fireStationVo.setFireEquipmentInfo(this.fireEquipMapper.queryStorageEquips(fireStationVo.getRiskSourceId()));
                    returnEntity = fireStationVo;
                }
                break;
            case extinguisher:
            case hydrant:
            case monitorEquipment:
                FireEquipmentBo fireEquipment = fireEquipMapper.findFireEquipById(id);
                fireEquipment.setEquipClassify(Integer.parseInt(EquipClassifyEnum.EQUIPMENT.getCode()));
                returnEntity = fireEquipment;
                break;
            case video:
                FireEquipmentBo fireVideo = fireEquipMapper.findVideoById(id);
                fireVideo.setEquipClassify(Integer.parseInt(EquipClassifyEnum.VIDEO.getCode()));
                returnEntity = fireVideo;
                break;

            case fireDetection:
                FireEquipmentBo fireDetection = fireEquipMapper.findFireEquipById(id);

                fireDetection.setProtectObjNames(this.impEquipMapper.queryProtectObjNames(fireDetection.getId()));

                returnEntity = fireDetection;
                break;
            default:
                throw new Exception("类型有误.");

        }
        return returnEntity;
    }

//    @Override
//    public int countAssociatedEquipStationByIds(String[] ids) {
//        return iFireEquipmentDao.countAssociatedEquipStationByIds(ids);
//    }


//    @Override
//    public Boolean isExistByCode(String code) {
//        Optional<FireEquipment> optional = iFireEquipmentDao.findByCode(code);
//        return optional.isPresent();
//    }

}
