package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.common.api.entity.SourceFile;
import com.yeejoin.amos.boot.module.common.biz.service.impl.SourceFileServiceImpl;
import com.yeejoin.amos.boot.module.jcs.api.dto.OrgUsrSafeReportDto;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.OrgUsrSafeReportServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 机场单位消防安全报告
 *
 * @author litw
 * @date 2021-10-09
 */
@RestController
@Api(tags = "机场单位消防安全报告Api")
@RequestMapping(value = "/org-usr-safe-report")
public class OrgUsrSafeReportController extends BaseController {

    @Autowired
    OrgUsrSafeReportServiceImpl orgUsrSafeReportServiceImpl;

	@Autowired
	SourceFileServiceImpl sourceFileService;

    /**
     * 新增机场单位消防安全报告
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增机场单位消防安全报告", notes = "新增机场单位消防安全报告")
	public ResponseModel<OrgUsrSafeReportDto> save(@RequestBody OrgUsrSafeReportDto model) {
	    model = orgUsrSafeReportServiceImpl.createWithModel(model);
		if (ObjectUtils.isNotEmpty(model.getAttachments())) {
			saveAttachments(model);
		}
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/updateById")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新机场单位消防安全报告", notes = "根据sequenceNbr更新机场单位消防安全报告")
	public ResponseModel<OrgUsrSafeReportDto> updateBySequenceNbrOrgUsrSafeReport(@RequestBody OrgUsrSafeReportDto model) {
		if (ObjectUtils.isNotEmpty(model.getAttachments())) {
			saveAttachments(model);
		}
	    return ResponseHelper.buildResponse(orgUsrSafeReportServiceImpl.updateWithModel(model));
	}

	/**
     * 根据ids删除
     *
     * @param ids 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{ids}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除机场单位消防安全报告", notes = "根据sequenceNbr删除机场单位消防安全报告")
    public ResponseModel deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "ids") String ids){
		List<Long> seqs = StringUtil.String2LongList(ids);
		orgUsrSafeReportServiceImpl.deleteBatchSeq(seqs);
		return ResponseHelper.buildResponse(seqs);
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个机场单位消防安全报告",  notes = "根据sequenceNbr查询单个机场单位消防安全报告")
	public ResponseModel<OrgUsrSafeReportDto> selectOne(@PathVariable Long sequenceNbr) {
		OrgUsrSafeReportDto dto = orgUsrSafeReportServiceImpl.queryBySeq(sequenceNbr);
		dto.setAttachments(sourceFileService.getAttachments(sequenceNbr));
	    return ResponseHelper.buildResponse(dto);
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "机场单位消防安全报告分页查询",  notes = "机场单位消防安全报告分页查询")
	public ResponseModel<Page<OrgUsrSafeReportDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size, OrgUsrSafeReportDto orgUsrSafeReportDto) {
	    Page<OrgUsrSafeReportDto> page = new Page<>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(orgUsrSafeReportServiceImpl.queryForOrgUsrSafeReportPage(page,
				orgUsrSafeReportDto.getName(),
				orgUsrSafeReportDto.getTypeCode(),
				orgUsrSafeReportDto.getTakeEffectYear(),
				orgUsrSafeReportDto.getCompanyId()));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "机场单位消防安全报告列表全部数据查询",   notes = "机场单位消防安全报告列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<OrgUsrSafeReportDto>> selectForList() {
	    return ResponseHelper.buildResponse(orgUsrSafeReportServiceImpl.queryForOrgUsrSafeReportList());
	}

	public void saveAttachments(OrgUsrSafeReportDto orgUsrSafeReportDto) {
		if (!ValidationUtil.isEmpty(orgUsrSafeReportDto.getAttachments())) {
			List<SourceFile> sourceFiles = Lists.newArrayList();
			Map<String, List<AttachmentDto>> attachmentMap = orgUsrSafeReportDto.getAttachments();
			attachmentMap.entrySet().forEach(entry -> {
				List<AttachmentDto> atts = entry.getValue();
				sourceFiles.addAll(attachment2SourceFile(entry.getKey(), atts));
			});
			sourceFileService.saveSourceFile(orgUsrSafeReportDto.getSequenceNbr(), sourceFiles);
		}
	}

	private List<SourceFile> attachment2SourceFile(String type, List<AttachmentDto> attachmentDtoList) {
		List<SourceFile> sourceFiles = Lists.newArrayList();
		if (!ValidationUtil.isEmpty(attachmentDtoList)) {
			attachmentDtoList.forEach(a -> {
				SourceFile s = new SourceFile();
				s.setFilePath(a.getUrl());
				s.setFileName(a.getName());
				s.setFileCategory(type);
				sourceFiles.add(s);
			});
		}
		return sourceFiles;
	}
}
