package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jcs.api.dto.ShiftChangeInfoDto;
import com.yeejoin.amos.boot.module.jcs.api.service.IShiftChangeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;


/**
 * 交接班记录表
 *
 * @author system_generator
 * @date 2021-07-13
 */
@RestController
@Api(tags = "交接班模块Api")
@RequestMapping(value = "/shift-change")
public class ShiftChangeController extends BaseController {

    @Autowired
    IShiftChangeService iShiftChangeService;

    /**
     * 新增交接班记录表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增交接班记录表", notes = "新增交接班记录表")
    public ResponseModel save(@RequestBody ShiftChangeInfoDto model) {
        return ResponseHelper.buildResponse(iShiftChangeService.createFormAndEntry(Bean.BeantoMap(model)));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除交接班记录表", notes = "根据sequenceNbr删除交接班记录表")
    public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(iShiftChangeService.removeOneById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个交接班记录", notes = "根据sequenceNbr查询单个交接班记录")
    public ResponseModel selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(iShiftChangeService.getOneBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "交接班记录分页查询", notes = "交接班记录分页查询")
    public ResponseModel queryForPage(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size) {
        return ResponseHelper.buildResponse(iShiftChangeService.queryForShiftChangePage(current, size));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "交接班记录列表查询-不分页", notes = "交接班记录列表数据查询-不分页")
    @GetMapping(value = "/list")
    public ResponseModel selectForList() {
        return ResponseHelper.buildResponse(iShiftChangeService.queryForShiftChangeList());
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "pdf下载", notes = "pdf下载")
    @GetMapping("/pdf/export")
    public void exportPdf(HttpServletResponse response,@RequestParam Long shiftChangeId) {
        try {
            iShiftChangeService.exportPdfById(response, shiftChangeId);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
	}

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "上次最新记录", notes = "上次最新记录")
    @GetMapping("/lastRecord")
    public ResponseModel lastRecord(){
        return ResponseHelper.buildResponse(iShiftChangeService.lastRecord());
    }

}
