package com.yeejoin.amos.maintenance.task;

import com.yeejoin.amos.maintenance.business.service.intfc.IPlanTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @author DELL
 */
@Component
@EnableScheduling
public class PlanTaskJob {


    @Autowired
    private IPlanTaskService planTaskService;

    /**
     * 定时查询任务状态
     */
    @Scheduled(cron = "${jobs.cron}")
    public void scheduleJob() {
        planTaskService.taskExecution(null);
    }

    /**
     * 定时任务推送维保待办任务消息
     */
    @Scheduled(cron = "${jobs.cron}")
    public void taskMessage() {
        planTaskService.taskMessage(null);
    }
}
