package com.yeejoin.amos.supervision.business.dto;

import com.yeejoin.amos.component.rule.Label;
import com.yeejoin.amos.component.rule.RuleFact;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @Author: xl
 * @Description:  计划规则触发对象
 * @Date: 2021/11/10 10:01
 */
@Data
@RuleFact(value = "巡检计划",project = "消息规则")
public class PlanRo implements Serializable {

    private static final long serialVersionUID = 1070080521549842475L;

    @Label("计划名称")
    private String name;

    @Label(value = "检查类型名称")
    private String checkTypeName;

    @Label(value = "执行方法")
    private String ruleType;

    @Label(value = "执行状态")
    private String excuteStateName;

    @Label(value = "推送时间")
    private String sendTime;

    @Label(value = "接收人")
    private List<String> recivers;

    @Label(value = "发送到web标识")
    private Boolean isSendWeb;

    @Label(value = "发送到app标识")
    private Boolean isSendApp;

    @Label("关联id")
    private String relationId;

    @Label("消息类型")
    private String msgType;

    @Label(value = "终端标识")
    private String terminal;

    @Label(value = "类别")
    private Integer category;

    @Label("牵头部门")
    private String leadDepartmentNames;

    @Label(value = "扩展参数")
    private Map<String, String> extras;
}
