package com.yeejoin.amos.boot.module.ugp.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.UgpCompanyServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.UgpCompanyDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 企业信息表
 *
 * @author system_generator
 * @date 2022-09-21
 */
@RestController
@Api(tags = "企业信息表Api")
@RequestMapping(value = "/ugp-company")
public class UgpCompanyController extends BaseController {

    @Autowired
    UgpCompanyServiceImpl ugpCompanyServiceImpl;

    /**
     * 新增企业信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增企业信息表", notes = "新增企业信息表")
	public ResponseModel<UgpCompanyDto> save(@RequestBody UgpCompanyDto model) {
	    model = ugpCompanyServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新企业信息表", notes = "根据sequenceNbr更新企业信息表")
	public ResponseModel<UgpCompanyDto> updateBySequenceNbrUgpCompany(@RequestBody UgpCompanyDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(ugpCompanyServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除企业信息表", notes = "根据sequenceNbr删除企业信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(ugpCompanyServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个企业信息表",  notes = "根据sequenceNbr查询单个企业信息表")
	public ResponseModel<UgpCompanyDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(ugpCompanyServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "企业信息表分页查询",  notes = "企业信息表分页查询")
	public ResponseModel<Page<UgpCompanyDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<UgpCompanyDto> page = new Page<UgpCompanyDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(ugpCompanyServiceImpl.queryForUgpCompanyPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "企业信息表列表全部数据查询",   notes = "企业信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<UgpCompanyDto>> selectForList() {
	    return ResponseHelper.buildResponse(ugpCompanyServiceImpl.queryForUgpCompanyList());
	}
}
