/* 增加分类，提出标题至主表涉及的数据库变更 */
-- 添加文档表字段
ALTER TABLE knowledge_doc_content ADD DIRECTORY_ID BIGINT NOT NULL COMMENT '所属目录ID';
ALTER TABLE knowledge_doc_content ADD DOC_TITLE varchar(100) NOT NULL COMMENT '文档名称';

-- 根据动态字段值填充新字段
UPDATE knowledge_doc_content SET DOC_TITLE = (
  SELECT FIELD_VALUE FROM (
    SELECT FIELD_VALUE, INSTANCE_ID FROM knowledge_dynamics_value kdv WHERE FIELD_NAME = 'docTitle'
  ) AS a WHERE INSTANCE_ID = SEQUENCE_NBR 
), DIRECTORY_ID = (
  SELECT DIRECTORY FROM (
    SELECT CASE FIELD_VALUE WHEN 'FIRE_ FIGHTING' THEN 1 WHEN 'EMERGENCY_RESCUE' THEN 2 WHEN 'SOCIAL_ASSISTANCE' THEN 3 ELSE 0 END DIRECTORY, INSTANCE_ID FROM (
      SELECT FIELD_VALUE, INSTANCE_ID FROM knowledge_dynamics_value kdv WHERE FIELD_NAME = 'type'
    ) AS b
  ) AS c WHERE INSTANCE_ID = SEQUENCE_NBR
);

-- 删除动态表中的数据
DELETE FROM knowledge_dynamics_value WHERE FIELD_NAME in ('docTitle', 'type');

-- 删除配置
DELETE FROM knowledge_dynamics_option WHERE FIELD_NAME in ('docTitle', 'type');