package com.yeejoin.precontrol.common.dto;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.HazardousWorkResult;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @description: 三交三查
 * @author: duanwei
 * @date: 2020-07-17 15:48
 **/
@Data
public class SingTaskPayCheckDto extends BaseDto{

    //人员类型（0主持人，1交底人，2施工负责人，3安全员，4交底人员，5记录人，6技术员，7工程人员，8施工人员，9违章人员  99 发布人）
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "任务id")
    private Long id;
    @ApiModelProperty(value = "所属项目id")
    private Long projectId;
    @ApiModelProperty(value = "天气")
    private String weather;

    @ApiModelProperty(value = "施工任务")
    private Long constructionTask;

    @ApiModelProperty(value = "技术要求")
    private Long technicalRequire;

    @ApiModelProperty(value = "安全环保措施")
    private Long environmentProtect;

    @ApiModelProperty(value = "是否风险作业")
    private Long riskOperation;

    @ApiModelProperty(value = "风险作业类型Id")
    private Long riskTypeId;

    @ApiModelProperty(value = "风险作业类型")
    private String riskType;

    @ApiModelProperty(value = "平台安全员")
    private Long platformSafetyOfficerId;

    @ApiModelProperty(value = "安全员")
    private Long safetyOfficerId;

    @ApiModelProperty(value = "技术员")
    private List<Long> technicianId;

    @ApiModelProperty(value = "工程人员")
    private List<Long> engineeringStaffId;

    @ApiModelProperty(value = "施工人员")
    private List<Long> builderId;

    @ApiModelProperty(value = "着装")
    private Long dress;

    @ApiModelProperty(value = "三宝(安全帽、安全带、安全鞋)")
    private Long saftTreasure;

    @ApiModelProperty(value = "精神状态")
    private Long mentalState;

    @ApiModelProperty(value = "作业票id")
    private Long workTicketId;
    @ApiModelProperty(value = "作业票名称")
    private String workTicketName;

    @ApiModelProperty(value = "图片")
    @ImagePrefix
    private List<String> filePath;

    @ApiModelProperty(value = "作业票图片")
    @ImagePrefix
    private List<String> workTicketFilePath;

    @ApiModelProperty(value = "检查项")
    private List<HazardousWorkResult> hazardousWorkResultList;


    @ApiModelProperty(value = "平台检查项")
    private List<HazardousWorkResult> platformHazardousWorkResultList;

    @ApiModelProperty(value = "附件")
    @ImagePrefix
    private List<String> attachment;
}

