package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 项目关联分包商表
 *
 * @author duanwei
 * @date 2021-01-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_project_company")
@ApiModel(value = "ProjectCompany对象", description = "项目关联分包商表")
public class ProjectCompany extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "项目id")
	private Long projectId;

	@ApiModelProperty(value = "项目名称")
	@TableField(exist = false)
	private String projectName;

	@ApiModelProperty(value = "分包商id")
	private Long companyId;

	@ApiModelProperty(value = "分包商名称")
	@TableField(exist = false)
	private String companyName;
}
