package com.yeejoin.precontrol.common.enums;

/*
 * sqy
 * 劳动合同类型
 */
public enum HealthStatusEum {
    /*
     * 健康
     */
    健康("健康", "0"),
    /*
     *亚健康
     */
    亚健康("亚健康", "1"),
    /**
     * 不健康
     */
    不健康("不健康", "2"),
    /**
     * 其他
     */
    其他("其他", "3");

    private String label;
    private String value;

    HealthStatusEum(String label, String value) {
        this.label = label;
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static String getLabelByValue(String value) {
        String label = null;
        for (HealthStatusEum type : HealthStatusEum.values()) {
            if (type.getValue().equals(value)) {
                label = type.getLabel();
                break;
            }
        }
        return label;
    }
}
