package com.yeejoin.precontrol.common.enums;

public enum OfflineExamEnum {

	THREE_SEC("三级安全教育考试", 1L, "THREE_LEVEL_EXAM"),

	SEC_RE_TRAIN("安全再教育培训考试", 2L, "");

	private String label;
	private Long value;
	private String type;

	OfflineExamEnum(String label, Long value, String type) {
		this.label = label;
		this.value = value;
		this.type = type;
	}

	public String getType() {
		return type;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public Long getValue() {
		return value;
	}

	public void setValue(Long value) {
		this.value = value;
	}

	public static String getLabelByValue(Long value) {
		String label = null;
		for (OfflineExamEnum type : OfflineExamEnum.values()) {
			if (type.getValue().equals(value)) {
				label = type.getLabel();
				break;
			}
		}
		return label;
	}
}
