package com.yeejoin.precontrol.common.enums;

/**
 * @Description: 人员类型枚举
 * @Author: duanwei
 * @Date: 2020/10/29
 */
public enum TaskPersonTypeEnum {

	/**
	 * 主持人
	 */
	HOSTPERSON("主持人", 0L),
	/**
	 * 交底人
	 */
	DISCLOSUREPERSON("交底人", 1L),
	/**
	 * 施工负责人
	 */
	CONSTRUCTIONDIRECTOR("施工负责人", 2L),
	/**
	 * 分包商安全员
	 */
	SAFETYOFFICER("分包商安全员", 3L),
	/**
	 * 交底人员
	 */
	PARTICIPATEDISCLOSURE("交底人员", 4L),
	/**
	 * 记录人
	 */
	NOTETAKER("记录人", 5L),
	/**
	 * 技术员
	 */
	TECHNICIAN("技术员", 6L),
	/**
	 * 工程人员
	 */
	ENGINEERINGSTAFF("工程人员", 7L),
	/**
	 * 施工人员
	 */
	BUILDER("施工人员", 8L),
	/**
	 * 违章人员
	 */
	ILLEGAL("违章人员", 9L),
	/**
	 * 分包商负责人
	 */
	SUBCONTRACTOR("分包商负责人", 10L),
	/**
	 * 审核人
	 */
	REVIEWER("审核人", 11L),
	/**
	 * 违规发起人
	 */
	SPONSORVIOLATION("违规发起人", 12L),
	/**
	 *项目部安全员
	 */
	PLATFORMSAFETYOFFICER("项目部安全员", 13L),
	/**
	 * 分包商主管
	 */
	DIRECTOR("分包商主管", 14L),
	/**
	 * 薪资确认人
	 */
	SALARYCONFIRM("薪资确认人", 15L),
	/**
	 * 学习人
	 */
	STUDY("学习人", 16L),
	/**
	 * 专业施工人
	 */
    PRO_WORKER("专业施工人", 17L),
	/**
	 * 辅助施工人
	 */
    ASSIST_WORKER("辅助施工人", 18L),
	/**
	 *分包商班长
	 */
    MONITOR("分包商班长", 19L),
	/**
	 * 分包商技术员
	 */
    FBS_TECHNICIAN("分包商技术员", 20L),
	/**
	 * 发布人
	 */
	CREATEPERSON("发布人", 99L),
	
	/**
	 * 其他人员
	 */
	OTHER("其他人员",100L);

	private String label;
	private Long value;

	TaskPersonTypeEnum(String label, Long value) {
		this.label = label;
		this.value = value;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public Long getValue() {
		return value;
	}

	public void setValue(Long value) {
		this.value = value;
	}

	public static String getLabelByValue(Long value) {
		String label = null;
		for (TaskPersonTypeEnum type : TaskPersonTypeEnum.values()) {
			if (type.getValue().equals(value)) {
				label = type.getLabel();
				break;
			}
		}
		return label;
	}
}
