package com.yeejoin.precontrol.common.param;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 项目信息Dto
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
public class ProjectImportParam {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "主键")
    @Excel(name = "主键")
    private Long id;
    @ApiModelProperty(value = "项目名称")
    @Excel(name = "项目名称")
    private String name;
    @ApiModelProperty(value = "手机号码")
    @Excel(name = "手机号码")
    private Long phone;
    @ApiModelProperty(value = "项目经理")
    @Excel(name = "项目经理")
    private String manager;
    @ApiModelProperty(value = "邮箱")
    @Excel(name = "邮箱")
    private String email;
    @ApiModelProperty(value = "建设单位")
    @Excel(name = "建设单位")
    private String company;
    private String region;
    @ApiModelProperty(value = "地区名称")
    @Excel(name = "地区名称")
    private String regionName;
    @ApiModelProperty(value = "经度")
    @Excel(name = "经度")
    private Double longitude;
    @ApiModelProperty(value = "纬度")
    @Excel(name = "纬度")
    private Double latitude;
    @ApiModelProperty(value = "项目地址")
    @Excel(name = "项目地址")
    private String address;
    @ApiModelProperty(value = "状态")
    //replace = {"开发_0", "策划_1", "在建_2", "停建_3", "完工_4", "结算_5", "尾款_6", "关闭_7",
    //            "终止_8", "运维_9", "测试_10"}
    @Excel(name = "状态")
    private String status;
    @ApiModelProperty(value = "开始时间")
    @Excel(name = "开始时间", importFormat = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    @ApiModelProperty(value = "项目编号")
    @Excel(name = "项目编号")
    private String projectNum;
    @ApiModelProperty(value = "简介")
    @Excel(name = "简介")
    private String introduction;
    @ApiModelProperty(value = "分包商数量")
    @Excel(name = "分包商数量")
    private Integer companyNum;
    @ApiModelProperty(value = "施工人数")
    @Excel(name = "施工人数")
    private Integer personNum;
    @ApiModelProperty(value = "分包商ID")
    @Excel(name = "分包商ID")
    private String companyId;
    @ApiModelProperty(value = "创建时间")
    @Excel(name = "创建时间", importFormat = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;
    @Excel(name = "打卡范围（半径）")
    private Double clockScope;
    @Excel(name = "项目部")
    private String orgName;
}
