package com.yeejoin.precontrol.common.service.hk.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.hk.model.po.MediaConfig;
import com.yeejoin.precontrol.common.mapper.hk.MediaConfigMapper;
import com.yeejoin.precontrol.common.service.hk.IMediaConfigService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * @Author: songLei
 * @Description: 流媒体服务配置业务类
 * @Date: 2021/4/29 10:56
 * @Version: 1.0
 */
@Service
public class MediaConfigServiceImpl extends ServiceImpl<MediaConfigMapper, MediaConfig> implements IMediaConfigService {
    /**
     * @Author songLei
     * @Version 1.0
     * @Description 查询所有流媒体配置数据
     * @Date 2021/4/29 11:07
     */
    @Override
    public List<MediaConfig> findAll() {
        List<MediaConfig> mediaConfigs = this.list(new QueryWrapper<MediaConfig>()
                .lambda()
                .eq(MediaConfig::getIsDelete, Boolean.FALSE));
        return CollectionUtils.isNotEmpty(mediaConfigs) ? mediaConfigs : Collections.emptyList();
    }
}
