package com.yeejoin.precontrol.common.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.precontrol.common.constant.Constant;
import com.yeejoin.precontrol.common.dto.*;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.Project;
import com.yeejoin.precontrol.common.enums.*;
import com.yeejoin.precontrol.common.feign.ExamFeign;
import com.yeejoin.precontrol.common.feign.KnowledgeBaseFeign;
import com.yeejoin.precontrol.common.fileparser.utils.DateUtil;
import com.yeejoin.precontrol.common.mapper.*;
import com.yeejoin.precontrol.common.service.*;
import com.yeejoin.precontrol.common.utils.CommonResponseUtil;
import com.yeejoin.precontrol.common.utils.DateTools;
import com.yeejoin.precontrol.common.utils.StringUtil;
import com.yeejoin.precontrol.common.vo.*;
import com.yeejoin.precontrol.common.ws.WebSocketStatistics;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

@Service
@Slf4j
public class StatisticsServiceImpl implements IStatisticsService {

	@Autowired
	IProjectService projectService;
	@Autowired
	IPersonAscriptionService personAscriptionService;
	@Autowired
	ITaskService taskService;
	@Autowired
	ICompanyService companyService;
	@Autowired
	StatisticsMapper statisticsMapper;
	@Autowired
	TaskMapper taskMapper;
	@Autowired
	ProjectMapper projectMapper;
	@Autowired
	CompanyMapper companyMapper;
	@Autowired
	KnowledgeBaseFeign knowledgeBaseFeign;
	@Autowired
	IBadManagementService badManagementService;
	/**
	 * 项目分数服务
	 */
	@Autowired
	IProjectScoreService iProjectScoreService;
	@Autowired
	ITaskPersonService iTaskPersonService;
	@Autowired
	ExamFeign examFeign;
	@Autowired
	TaskSalaryConfirmMapper taskSalaryConfirmMapper;
	@Autowired
	PersonMapper personMapper;
	@Autowired
	TaskRiskControlMapper taskRiskControlMapper;
	@Autowired
	ITaskRiskControlService iTaskRiskControlService;
	@Autowired
	WebSocketStatistics webSocketStatistics;
	@Autowired
	IPersonService personService;
	@Autowired
	IRewardService rewardService;
	@Autowired
	IRetributionService retributionService;
	@Autowired
	TaskRiskControlTechMapper taskRiskControlTechMapper;
	/**
	 * 知识库分类目录字典key
	 */
	private final String DICT_CODE_KNOWLEDGE = "KNOWLEDGE_DIRECTORY";

	@Override
	public Map<String, Object> todayRegulate(StatisticsDto statisticsDto) {
		Map<String, Object> map = new HashMap<>();
//		LambdaQueryWrapper<Project> wrapperProject = new LambdaQueryWrapper<Project>().in(Project::getStatus,
//				Arrays.asList(Constant.BUILD_PROJECT_STATUS_GROUP));
//		if (statisticsDto.getOrgCode() != null) {
//			wrapperProject.eq(Project::getOrgCode, statisticsDto.getOrgCode());
//		}
//		if (statisticsDto.getProjectId() != null) {
//			wrapperProject.eq(Project::getId, statisticsDto.getProjectId());
//		}
//		List<Project> projects = iProjectService.list(wrapperProject);
		// 在建项目
		int projectCount = statisticsMapper.projectCount(statisticsDto,
				Arrays.asList(Constant.BUILD_PROJECT_STATUS_GROUP));
		map.put("projectCount", projectCount);
		// 风险作业
		int riskCount = statisticsMapper.riskControlCount(statisticsDto, true, null, null);
		map.put("riskCount", riskCount);
		// 今日违章
		int badCount = statisticsMapper.badCount(statisticsDto, true, null);
		map.put("badCount", badCount);
		// 技术交底
		int techCount = statisticsMapper.taskCount(statisticsDto, true, TaskTypeEnum.JOBDISCLOSURE.getValue(), null,
				null);
		map.put("techCount", techCount);
		// 未交底人员
		int noTechWorkPersonCount = statisticsMapper.inPersonCount(statisticsDto, true, "fbs_worker", true);
		map.put("noTechPersonCount", noTechWorkPersonCount);
		// 入场人员
		int inPersonCount = statisticsMapper.inPersonCount(statisticsDto, false, null, false);
		map.put("inPersonCount", inPersonCount);
		// 作业票
		int ticketCount = statisticsMapper.ticketCount(statisticsDto, true, null, null);
		map.put("ticketCount", ticketCount);
		return map;
	}

	@Override
	public Map<String, Object> todayRegulateProject(StatisticsDto statisticsDto) {
		Map<String, Object> map = new HashMap<>();
		// 所有项目
		int projectAllCount = statisticsMapper.projectCount(statisticsDto, null);
		map.put("projectAllCount", projectAllCount);
		// 在建项目
		int projectCount = statisticsMapper.projectCount(statisticsDto,
				Arrays.asList(Constant.BUILD_PROJECT_STATUS_GROUP));
		map.put("projectCount", projectCount);
		// 项目人数
		int projectPersonCount = statisticsMapper.projectPersonCount(statisticsDto, TypeKeyEnum.COMPANY.getLongType(),
				Arrays.asList(Constant.BUILD_PROJECT_STATUS_GROUP), null);
		map.put("projectPersonCount", projectPersonCount);
		// 分包商人数
		int companyPersonCount = statisticsMapper.companyPersonCount(statisticsDto, TypeKeyEnum.COMPANY.getLongType(),
				Arrays.asList(Constant.BUILD_PROJECT_STATUS_GROUP), PersonBlackEnum.NO.getLongType(), true);
		map.put("companyPersonCount", companyPersonCount);
		return map;
	}

	@Override
	public Map<String, Object> todayRegulateRisk(StatisticsDto statisticsDto) {
		Map<String, Object> map = new HashMap<>();
		// 风险作业
		int riskCount = statisticsMapper.riskControlCount(statisticsDto, true, null, null);
		map.put("riskCount", riskCount);
		// 所有项目
		int projectCount = statisticsMapper.projectCount(statisticsDto,
				Arrays.asList(Constant.BUILD_PROJECT_STATUS_GROUP));
		map.put("projectCount", projectCount);
		// 风险作业项目
		int riskProjectCount = statisticsMapper.riskProjectCount(statisticsDto, true);
		map.put("riskProjectCount", riskProjectCount);
		// 风险作业分包商
		int riskCompanyCount = statisticsMapper.riskCompanyCount(statisticsDto, true);
		map.put("riskCompanyCount", riskCompanyCount);
		return map;
	}

	@Override
	public Map<String, Object> todayRegulateBad(StatisticsDto statisticsDto) {
		Map<String, Object> map = new HashMap<>();
		// 人员违章
		int badPersonCount = statisticsMapper.badCount(statisticsDto, true, BadTypeEnum.PERSON.getLabel());
		map.put("badPersonCount", badPersonCount);
		// 装置性违章
		int badDeviceCount = statisticsMapper.badCount(statisticsDto, true, BadTypeEnum.DEVICE.getLabel());
		map.put("badDeviceCount", badDeviceCount);
		// 指挥性违章
		int badCommandCount = statisticsMapper.badCount(statisticsDto, true, BadTypeEnum.COMMAND.getLabel());
		map.put("badCommandCount", badCommandCount);
		// 违章项目
		int badProjectCount = statisticsMapper.badProjectCount(statisticsDto, true);
		map.put("badProjectCount", badProjectCount);
		// 违章分包商
		int badCompanyCount = statisticsMapper.badCompanyCount(statisticsDto, true);
		map.put("badCompanyCount", badCompanyCount);
		return map;
	}

	@Override
	public Map<String, Object> todayRegulateTech(StatisticsDto statisticsDto) {
		Map<String, Object> map = new HashMap<>();
		// 技术交底人员
		int techPersonCount = statisticsMapper.techPersonCount(statisticsDto, true);
		map.put("techPersonCount", techPersonCount);
		// 入场人员
		int inPersonCount = statisticsMapper.inPersonCount(statisticsDto, true, null, false);
		map.put("inPersonCount", inPersonCount);
		// 交底项目数
		int techProjectCount = statisticsMapper.techProjectCount(statisticsDto, true);
		map.put("techProjectCount", techProjectCount);
		// 交底分包商数
		int techCompanyCount = statisticsMapper.techCompanyCount(statisticsDto, true);
		map.put("techCompanyCount", techCompanyCount);
		return map;
	}

	@Override
	public Map<String, Object> todayRegulatePersonIn(StatisticsDto statisticsDto) {
		Map<String, Object> map = new HashMap<>();
		// 入场人员
		int inPersonCount = statisticsMapper.inPersonCount(statisticsDto, false, null, false);
		map.put("inPersonCount", inPersonCount);
		// 入岗人员
		int projectPersonCount = statisticsMapper.projectPersonCount(statisticsDto, TypeKeyEnum.COMPANY.getLongType(),
				Arrays.asList(Constant.BUILD_PROJECT_STATUS_GROUP), null);
		map.put("projectPersonCount", projectPersonCount);
		// 入场项目（人员）
		int inProjectCount = statisticsMapper.inProjectCount(statisticsDto, false, false);
		map.put("inProjectCount", inProjectCount);
		// 入场分包商（人员）
		int inCompanyCount = statisticsMapper.inCompanyCount(statisticsDto, false, false);
		map.put("inCompanyCount", inCompanyCount);
		return map;
	}

	@Override
	public Map<String, Object> todayRegulatePersonNoTech(StatisticsDto statisticsDto) {
		Map<String, Object> map = new HashMap<>();
		// 入场施工人员
		int inWorkPersonCount = statisticsMapper.inPersonCount(statisticsDto, true, "fbs_worker", false);
		map.put("inWorkPersonCount", inWorkPersonCount);
		// 未交底施工人员
		int noTechWorkPersonCount = statisticsMapper.inPersonCount(statisticsDto, true, "fbs_worker", true);
		map.put("noTechWorkPersonCount", noTechWorkPersonCount);
		// 入场项目（人员）
		int inProjectCount = statisticsMapper.inProjectCount(statisticsDto, true, false);
		map.put("inProjectCount", inProjectCount);
		// 未完成交底项目
		int noTechProjectCount = statisticsMapper.inProjectCount(statisticsDto, true, true);
		map.put("noTechProjectCount", noTechProjectCount);
		// 入场分包商（人员）
		int inCompanyCount = statisticsMapper.inCompanyCount(statisticsDto, true, false);
		map.put("inCompanyCount", inCompanyCount);
		// 未完成交底分包商
		int noTechCompanyCount = statisticsMapper.inCompanyCount(statisticsDto, true, true);
		map.put("noTechCompanyCount", noTechCompanyCount);
		return map;
	}

	@Override
	public Map<String, Object> todayRegulateTicket(StatisticsDto statisticsDto) {
		Map<String, Object> map = new HashMap<>();
		// 作业票
		int ticketCount = statisticsMapper.ticketCount(statisticsDto, true, null, null);
		map.put("ticketCount", ticketCount);
		// 三交三查
		int threeCount = statisticsMapper.taskCount(statisticsDto, true, TaskTypeEnum.TASKPAYCHECK.getValue(), null,
				null);
		map.put("threeCount", threeCount);
		// 作业项目
		int ticketProjectCount = statisticsMapper.ticketProjectCount(statisticsDto, true);
		map.put("ticketProjectCount", ticketProjectCount);
		// 作业分包商
		int ticketCompanyCount = statisticsMapper.ticketCompanyCount(statisticsDto, true);
		map.put("ticketCompanyCount", ticketCompanyCount);
		return map;
	}

	@Override
	public Map<String, Object> comprehensiveStatistical(StatisticsDto statisticsDto) {
		Map<String, Object> map = new HashMap<>();
		// 项目
		int projectCount = statisticsMapper.projectCount(statisticsDto, null);
		map.put("projectCount", projectCount);
		// 分包商
		int companyCount = statisticsMapper.companyCount(statisticsDto, false);
		map.put("companyCount", companyCount);
		// 人员
		int personCount = statisticsMapper.personCount(statisticsDto, false, TypeKeyEnum.COMPANY.getLongType());
		map.put("personCount", personCount);
		// 上岗人员
		int dutyPersonCount = statisticsMapper.projectPersonCount(statisticsDto, TypeKeyEnum.COMPANY.getLongType(),
				null, null);
		map.put("dutyPersonCount", dutyPersonCount);
		// 三交三查
		int threeCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.TASKPAYCHECK.getValue(), null,
				null);
		map.put("threeCount", threeCount);
		// 风险作业
		int riskCount = statisticsMapper.riskControlCount(statisticsDto, false, null, null);
		map.put("riskCount", riskCount);
		// 违章任务
		int badCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(), null, null);
		map.put("badCount", badCount);
		// 技术交底
		int techCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.JOBDISCLOSURE.getValue(), null,
				null);
		map.put("techCount", techCount);
		return map;
	}

	@Override
	public Map<String, Object> operationActivities(StatisticsDto statisticsDto) {
		Map<String, Object> map = new HashMap<>();
		// 三交三查
		Map<String, Object> threeMap = new HashMap<>();
		map.put("three", threeMap);
		// 三交三查-进行中
		int threeProgressCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.TASKPAYCHECK.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());
		threeMap.put("progress", threeProgressCount);
		// 三交三查-进行中-风险
		int threeProgressRiskCount = statisticsMapper.riskCount(statisticsDto, false,
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());
		threeMap.put("progressRisk", threeProgressRiskCount);
		// 三交三查-已完成
		int threeCompleteCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.TASKPAYCHECK.getValue(),
				TaskStatusEnum.COMPLETED.getLongType(), null);
		threeMap.put("complete", threeCompleteCount);
		// 三交三查-已完成-风险
		int threeCompleteRiskCount = statisticsMapper.riskCount(statisticsDto, false,
				TaskStatusEnum.COMPLETED.getLongType(), null);
		threeMap.put("completeRisk", threeCompleteRiskCount);
		// 三交三查-已超时
		int threeOverTimeCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.TASKPAYCHECK.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		threeMap.put("overtime", threeOverTimeCount);
		// 三交三查-已超时-风险
		int threeOverTimeRiskCount = statisticsMapper.riskCount(statisticsDto, false,
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		threeMap.put("overtimeRisk", threeOverTimeRiskCount);
		// 技术交底
		Map<String, Object> techMap = new HashMap<>();
		map.put("tech", techMap);
		// 技术交底-进行中
		int techProgressCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.JOBDISCLOSURE.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());
		techMap.put("progress", techProgressCount);
		// 技术交底-已完成
		int techCompleteCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.JOBDISCLOSURE.getValue(),
				TaskStatusEnum.COMPLETED.getLongType(), null);
		techMap.put("complete", techCompleteCount);
		// 技术交底-已超时
		int techOvertimeCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.JOBDISCLOSURE.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		techMap.put("overtime", techOvertimeCount);
		// 违章任务
		Map<String, Object> badMap = new HashMap<>();
		map.put("bad", badMap);
		// 违章任务-进行中
		int badProgressCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());
		int badProgressCount1 = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.TOAUDIT.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());
		int badProgressCount2 = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.RETURNED.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());
		badMap.put("progress", badProgressCount + badProgressCount1 + badProgressCount2);
		// 违章任务-已完成
		int badCompleteCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.COMPLETED.getLongType(), null);
		badMap.put("complete", badCompleteCount);
		// 违章任务-已超时
		int badOvertimeCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		int badOvertimeCount1 = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.TOAUDIT.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		int badOvertimeCount2 = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.RETURNED.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		badMap.put("overtime", badOvertimeCount + badOvertimeCount1 + badOvertimeCount2);
		// 知识分享
		Map<String, Object> knowledgeMap = new HashMap<>();
		map.put("knowledge", knowledgeMap);
		// 知识分享-进行中
		int knowledgeProgressCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.KNOWLEDGE_SHARE.getValue(), TaskStatusEnum.UNCOMPLETED.getLongType(),
				TaskCurrentStatusEnum.PROGRESS.getLongValue());
		knowledgeMap.put("progress", knowledgeProgressCount);
		// 知识分享-已完成
		int knowledgeCompleteCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.KNOWLEDGE_SHARE.getValue(), TaskStatusEnum.COMPLETED.getLongType(), null);
		knowledgeMap.put("complete", knowledgeCompleteCount);
		// 知识分享-已超时
		int knowledgeOvertimeCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.KNOWLEDGE_SHARE.getValue(), TaskStatusEnum.UNCOMPLETED.getLongType(),
				TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		knowledgeMap.put("overtime", knowledgeOvertimeCount);
		// 薪资确认
		Map<String, Object> salaryMap = new HashMap<>();
		map.put("salary", salaryMap);
		// 薪资确认-进行中
		int salaryProgressCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.SALARY_CONFIRM.getValue(), TaskStatusEnum.UNCOMPLETED.getLongType(),
				TaskCurrentStatusEnum.PROGRESS.getLongValue());
		salaryMap.put("progress", salaryProgressCount);
		// 薪资确认-已完成
		int salaryCompleteCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.SALARY_CONFIRM.getValue(), TaskStatusEnum.COMPLETED.getLongType(), null);
		salaryMap.put("complete", salaryCompleteCount);
		// 薪资确认-已超时
		int salaryOvertimeCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.SALARY_CONFIRM.getValue(), TaskStatusEnum.UNCOMPLETED.getLongType(),
				TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		salaryMap.put("overtime", salaryOvertimeCount);

		// 风险作业
		Map<String, Object> riskWorkMap = new HashMap<>();
		map.put("riskWork", riskWorkMap);
		// 风险作业-未开始
		TaskRiskControlDto taskRiskControlDto = new TaskRiskControlDto();
		taskRiskControlDto.setToStart(true);
		taskRiskControlDto.setOrgCode(statisticsDto.getOrgCode());
		taskRiskControlDto.setPersonId(statisticsDto.getPersonId());
		CommonPageableDto pageable = new CommonPageableDto(1);
		Page<TaskRiskControlVo> risk = iTaskRiskControlService.myListByPage(pageable, null, taskRiskControlDto);
		int riskUnstartCount = (int) (risk != null ? risk.getTotal() : 0);
		riskWorkMap.put("unstart", riskUnstartCount);
		// 风险作业-进行中
		int riskProgressCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.RISK.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());
		riskWorkMap.put("progress", riskProgressCount);
		// 风险作业-已完成
		int riskCompleteCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.RISK.getValue(),
				TaskStatusEnum.COMPLETED.getLongType(), null);
		riskWorkMap.put("complete", riskCompleteCount);
		// 风险作业-已超时
		int riskOvertimeCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.RISK.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		riskWorkMap.put("overtime", riskOvertimeCount);
		return map;
	}

	@Override
	public Map<String, Integer> getProjectStatistics(StatisticsDto statisticsDto) {
		Map<String, Integer> result = Maps.newHashMap();
		Integer score = iProjectScoreService.allProjectAvgScore(statisticsDto.getOrgCode());
		// 技术交底-进行中
		int techProgressCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.JOBDISCLOSURE.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());
		// 三交三查-进行中
		int threeProgressCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.TASKPAYCHECK.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());
		// 违章任务-进行中
		int badProgressCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());
		int badProgressCount1 = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.TOAUDIT.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());
		int badProgressCount2 = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.RETURNED.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());
		// 知识分享-进行中
		int knowledgeProgressCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.KNOWLEDGE_SHARE.getValue(), TaskStatusEnum.UNCOMPLETED.getLongType(),
				TaskCurrentStatusEnum.PROGRESS.getLongValue());
		// 薪资确认-进行中
		int salaryProgressCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.SALARY_CONFIRM.getValue(), TaskStatusEnum.UNCOMPLETED.getLongType(),
				TaskCurrentStatusEnum.PROGRESS.getLongValue());
		// 风险作业-进行中
		int riskProgressCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.RISK.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());

		// 技术交底-已完成
		int techCompleteCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.JOBDISCLOSURE.getValue(),
				TaskStatusEnum.COMPLETED.getLongType(), null);
		// 三交三查-已完成
		int threeCompleteCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.TASKPAYCHECK.getValue(),
				TaskStatusEnum.COMPLETED.getLongType(), null);
		// 违章任务-已完成
		int badCompleteCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.COMPLETED.getLongType(), null);
		// 知识分享-已完成
		int knowledgeCompleteCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.KNOWLEDGE_SHARE.getValue(), TaskStatusEnum.COMPLETED.getLongType(), null);
		// 薪资确认-已完成
		int salaryCompleteCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.SALARY_CONFIRM.getValue(), TaskStatusEnum.COMPLETED.getLongType(), null);
		int riskCompleteCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.RISK.getValue(),
				TaskStatusEnum.COMPLETED.getLongType(), null);

		// 技术交底-已超时
		int techOvertimeCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.JOBDISCLOSURE.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		// 三交三查-已超时
		int threeOverTimeCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.TASKPAYCHECK.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		// 违章任务-已超时
		int badOvertimeCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		int badOvertimeCount1 = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.TOAUDIT.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		int badOvertimeCount2 = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.BAD.getValue(),
				TaskStatusEnum.RETURNED.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		// 知识分享-已超时
		int knowledgeOvertimeCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.KNOWLEDGE_SHARE.getValue(), TaskStatusEnum.UNCOMPLETED.getLongType(),
				TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		// 薪资确认-已超时
		int salaryOvertimeCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.SALARY_CONFIRM.getValue(), TaskStatusEnum.UNCOMPLETED.getLongType(),
				TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		// 风险作业-已超时
		int riskOvertimeCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.RISK.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		result.put("score", score); // 安全态势分数
		result.put("processing", techProgressCount + threeProgressCount + badProgressCount + badProgressCount1
				+ badProgressCount2 + knowledgeProgressCount + salaryProgressCount + riskProgressCount); // 进行中任务
		result.put("finished", techCompleteCount + threeCompleteCount + badCompleteCount + knowledgeCompleteCount
				+ salaryCompleteCount + riskCompleteCount); // 已完成任务
		result.put("overdue", techOvertimeCount + threeOverTimeCount + badOvertimeCount + badOvertimeCount1
				+ badOvertimeCount2 + knowledgeOvertimeCount + salaryOvertimeCount + riskOvertimeCount); // 已超时任务
		return result;
	}

	@Override
	public Object taskStatistics(StatisticsDto statisticsDto) {
		Map<String, Object> result = new HashMap<>(3);
		// 1.风险作业
		// 风险作业-未开始
		TaskRiskControlDto taskRiskControlDto = new TaskRiskControlDto();
		taskRiskControlDto.setToStart(true);
		taskRiskControlDto.setOrgCode(statisticsDto.getOrgCode());
		taskRiskControlDto.setPersonId(statisticsDto.getPersonId());
		CommonPageableDto pageable = new CommonPageableDto(1);
		Page<TaskRiskControlVo> risk = iTaskRiskControlService.myListByPage(pageable, null, taskRiskControlDto);
		int riskUnstartCount = (int) (risk != null ? risk.getTotal() : 0);
		// 风险作业-进行中
		int riskProgressCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.RISK.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.PROGRESS.getLongValue());
		// 风险作业-已超时
		int riskOvertimeCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.RISK.getValue(),
				TaskStatusEnum.UNCOMPLETED.getLongType(), TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		result.put("riskWork", riskUnstartCount + riskProgressCount + riskOvertimeCount);
		// 2.知识推送
		// 进行中
		int knowledgeProgressCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.KNOWLEDGE_SHARE.getValue(), TaskStatusEnum.UNCOMPLETED.getLongType(),
				TaskCurrentStatusEnum.PROGRESS.getLongValue());
		// 已超时
		int knowledgeOvertimeCount = statisticsMapper.taskCount(statisticsDto, false,
				TaskTypeEnum.KNOWLEDGE_SHARE.getValue(), TaskStatusEnum.UNCOMPLETED.getLongType(),
				TaskCurrentStatusEnum.UNCOMPLETE.getLongValue());
		result.put("knowledge", knowledgeProgressCount + knowledgeOvertimeCount);
		// 3.考试推送
		ResponseModel<Map<String, Object>> responseModel = examFeign
				.getExamStatisticsData(statisticsDto.getUserId().toString());
		result.put("exam", 0);
		if (responseModel != null) {
			Map<String, Object> examCountData = responseModel.getResult();
			result.put("exam", examCountData != null ? examCountData.get("waitExam") : null);
		}
		return result;
	}

	@Override
	public Map<String, Object> safetyAnalysis(StatisticsDto statisticsDto) {
		Map<String, Object> map = new HashMap<>();
		// 项目总数
		int projectCount = statisticsMapper.projectCount(statisticsDto, null);
		map.put("projectCount", projectCount);
		int badProjectCount = statisticsMapper.badProjectCount(statisticsDto, false);
		// map.put("badProjectCount", badProjectCount);
		// 无违章项目数
		map.put("noProjectCount", projectCount - badProjectCount);
		// 分包商总数
		int companyCount = statisticsMapper.companyCount(statisticsDto, false);
		map.put("companyCount", companyCount);
		int badCompanyCount = statisticsMapper.badCompanyCount(statisticsDto, false);
		// map.put("badCompanyCount", badCompanyCount);
		// 无违章分包商数
		map.put("noCompanyCount", companyCount - badCompanyCount);
		// 作业活动总数
		int taskCount = statisticsMapper.taskCount(statisticsDto, false, null, null, null);
		map.put("taskCount", taskCount);
		// 未完成作业活动数
		int unTaskCount = statisticsMapper.taskCount(statisticsDto, false, null,
				TaskStatusEnum.UNCOMPLETED.getLongType(), null);
		int unTaskCount1 = statisticsMapper.taskCount(statisticsDto, false, null, TaskStatusEnum.TOAUDIT.getLongType(),
				null);
		int unTaskCount2 = statisticsMapper.taskCount(statisticsDto, false, null, TaskStatusEnum.RETURNED.getLongType(),
				null);
		map.put("unTaskCount", unTaskCount + unTaskCount1 + unTaskCount2);
		return map;
	}

	@Override
	public Map<String, Object> knowledgeShare(StatisticsDto statisticsDto) {
		Map<String, Object> map = new HashMap<>();
		// 知识分享
		int knowledgeCount = statisticsMapper.taskCount(statisticsDto, false, TaskTypeEnum.KNOWLEDGE_SHARE.getValue(),
				null, null);
		map.put("knowledgeCount", knowledgeCount);
		// 推送学习人数
		int knowledgePersonCount = statisticsMapper.taskPersonCount(statisticsDto,
				TaskTypeEnum.KNOWLEDGE_SHARE.getValue());
		map.put("knowledgePersonCount", knowledgePersonCount);
		return map;
	}

	@Override
	public Map<String, Object> statisticsToday(StatisticsDto statisticsDto) {
		String day = DateTools.getPastDate(0);
		String start = day + " 00:00:00";
		String end = day + " 23:59:59";
		Map<String, Object> map = new HashMap<>();
		map.put("companyPersonNum", Constant.ZERO);
		map.put("inClockCompanyPersonNum", Constant.ZERO);
		map.put("nojobPersonNum", Constant.ZERO);
		map.put("badNum", Constant.ZERO);
		map.put("projectPersonNum", Constant.ZERO);
		// 分包商人员
		int companyPersonNum = statisticsMapper.companyPersonCount(statisticsDto, TypeKeyEnum.COMPANY.getLongType(),
				null, null, true);
		map.put("companyPersonNum", companyPersonNum);
		// 入场分包商人员
//		LambdaQueryWrapper<PersonClock> personClockLambdaQueryWrapper = new LambdaQueryWrapper<>();
//
//		if (StringUtils.isNotEmpty(statisticsDto.getOrgCode())) {
//			personClockLambdaQueryWrapper.likeRight(PersonClock::getOrgCode, statisticsDto.getOrgCode());
//		}
//		personClockLambdaQueryWrapper.select(PersonClock::getPersonId).eq(PersonClock::getInOrOut, 0)
//				.between(PersonClock::getClockTime, start, end).groupBy(PersonClock::getPersonId);
//		List<PersonClock> personClockList = iPersonClockService.list(personClockLambdaQueryWrapper);
//		if (StringUtil.isNotEmpty(personClockList)) {
//			map.put("inClockCompanyPersonNum", personClockList.size());
//		}
		int inClockCompanyPersonNum = statisticsMapper.inPersonCount(statisticsDto, false, null, false);
		map.put("inClockCompanyPersonNum", inClockCompanyPersonNum);
		// 未交底人
		int nojobPersonNum = 0;
		Page<?> page = new Page<>(0, Integer.MAX_VALUE);
		NoJobPersonDto noJobPersonDto = new NoJobPersonDto();
		noJobPersonDto.setOrgCode(statisticsDto.getOrgCode());
		IPage<NoJobPersonVo> noJobPersonList = taskMapper.noJobPerson(page, noJobPersonDto);
		List<NoJobPersonVo> records = noJobPersonList.getRecords();
		if (StringUtil.isNotEmpty(records)) {
			nojobPersonNum = records.size();
			map.put("nojobPersonNum", nojobPersonNum);
		}

		// 今日违章人员
		int badNum = 0;
		IPage<BadPersonVo> badPersonList = taskMapper.badPersonList(page, new BadPersonDto());
		List<BadPersonVo> badPersonVos = badPersonList.getRecords();

		if (StringUtil.isNotEmpty(badPersonVos)) {
			badNum = badPersonVos.size();
			map.put("badNum", badNum);
		}
		return map;
	}

	@Override
	public List getTaskDetail(Long sequenceNbr, String userId) {
		List<Map<String, Object>> result = new ArrayList<>();
		// 风险作业
		Map<String, Object> riskWork = this.countRiskWork(sequenceNbr);
		result.add(riskWork);
		// 我的考试
		Map<String, Object> exam = this.countExam(userId);
		result.add(exam);
		// 违章检查
		Map<String, Object> badCheck = this.countBadCheck(sequenceNbr);
		result.add(badCheck);
		// 知识推送
		Map<String, Object> knowledgeShare = this.countTaskByTypeAndPersonAndStatus(sequenceNbr,
				TaskTypeEnum.KNOWLEDGE_SHARE);
		result.add(knowledgeShare);
		// 技术交底
		Map<String, Object> jobDisclosure = this.countTaskByTypeAndPersonAndStatus(sequenceNbr,
				TaskTypeEnum.JOBDISCLOSURE);
		result.add(jobDisclosure);
		// 三交三查
		Map<String, Object> taskPayCheck = this.countTaskByTypeAndPersonAndStatus(sequenceNbr,
				TaskTypeEnum.TASKPAYCHECK);
		result.add(taskPayCheck);
		// 薪资确认
		Map<String, Object> salaryConfirm = this.countTaskByTypeAndPersonAndStatus(sequenceNbr,
				TaskTypeEnum.SALARY_CONFIRM);
		result.add(salaryConfirm);
		return result;
	}

	@Override
	public List getKnowledgeRandomList(Integer total) {
		List<Map<String, Object>> knowledge = new ArrayList<>();
		// 1.数据准备，在字典获取知识库分类ids
		String ids = this.buildKnowledgeDirectory();
		// 2.调用知识库查询
		if (StringUtil.isNotEmpty(ids)) {
			if (log.isInfoEnabled()) {
				log.info("请求知识库查询随机数知识列表，请求参数:{},{}", ids, total);
			}
			ResponseModel<List<Map<String, Object>>> responseModel = knowledgeBaseFeign.getRandomList(ids, total);
			if (responseModel != null) {
				knowledge = responseModel.getResult();
			}
		}
		return knowledge;
	}

	@Override
	public Object getTaskDealStatus(Person person, Long companyId, Long projectId) {
		Map<String, Object> result = new HashMap<>();
		Long personId = person.getId();
		for (MyTodoAppMenuEum eum : MyTodoAppMenuEum.values()) {
			int num = 0;
			switch (eum) {
			case technology:
			case three2:
			case violateCheck:
			case konwledgePush:
				num = taskMapper.myToDoListCount(eum.getType(), personId);
				result.put(eum.getCode(), num);
				break;
			case myExam:
				result.put(eum.getCode(), 0);
				ResponseModel<PageInfo> responseModel = examFeign.getExamStatisticsList();
				if (responseModel != null) {
					num = responseModel.getResult().getSize();
					result.put(eum.getCode(), num);
				}
				break;
			case wages:
				num = taskSalaryConfirmMapper.firstReadCount(personId);
				result.put(eum.getCode(), num);
				break;
			case personVerify:
				if (projectId != null) {
					if (person.getIsJxdj() == 1) {
						num = personMapper.waitVerifyCount(PersonCheckStatus.CHECK_PASS.getStatus(), null, projectId);
					} else {
						num = personMapper.waitVerifyCount(PersonCheckStatus.WAIT_REGISTER.getStatus(), companyId,
								projectId);
					}
				}
				result.put(eum.getCode(), num);
				break;
			case riskWork:
				num = taskRiskControlMapper.myListCount(personId);
				result.put(eum.getCode(), num);
				break;
			case riskTech:
				num = taskRiskControlTechMapper.myListCount(personId);
				result.put(eum.getCode(), num);
				break;
			default:
				break;
			}
		}
		return result;
	}

	private String buildKnowledgeDirectory() {
		String idsStr = null;
		FeignClientResult<List<DictionarieValueModel>> feignClientResult = Systemctl.dictionarieClient
				.dictValues(DICT_CODE_KNOWLEDGE);
		if (feignClientResult != null) {
			List<DictionarieValueModel> dicts = feignClientResult.getResult();
			List<String> ids = dicts.stream().map(DictionarieValueModel::getDictDataValue).collect(Collectors.toList());
			idsStr = Joiner.on(",").join(ids);
		}
		return idsStr;
	}

	private Map<String, Object> countBadCheck(Long sequenceNbr) {
		Map<String, Object> resultInfo = statisticsMapper.countBadCheck(sequenceNbr);
		resultInfo.put("typeKey", TaskTypeEnum.BAD.getValue());
		resultInfo.put("typeLabel", "违章检查");
		return resultInfo;
	}

	private Map<String, Object> countRiskWork(Long sequenceNbr) {
		Map<String, Object> resultInfo = statisticsMapper.countRiskWork(sequenceNbr);
		resultInfo.put("typeKey", TaskTypeEnum.RISK.getValue());
		resultInfo.put("typeLabel", "风险作业");
		return resultInfo;
	}

	private Map<String, Object> countTaskByTypeAndPersonAndStatus(Long personId, TaskTypeEnum eum) {
		Map<String, Object> resultInfo = statisticsMapper.countTaskByTypeAndPersonAndStatus(personId, eum.getValue());
		resultInfo.put("typeKey", eum.getValue());
		resultInfo.put("typeLabel", eum.getLabel());
		return resultInfo;
	}

	private Map<String, Object> countExam(String userId) {
		ResponseModel<Map<String, Object>> responseModel = examFeign.getExamStatisticsData(userId);
		Map<String, Object> examCountData = responseModel.getResult();
		Map<String, Object> item = new HashMap<>();
		item.put("typeKey", 7);
		item.put("typeLabel", "我的考试");
		item.put("waitNum", examCountData.get("waitExam"));
		item.put("progressNum", examCountData.get("haveInHand"));
		item.put("timeOutNum", examCountData.get("overtime"));
		item.put("finishNum", examCountData.get("completed"));
		return item;
	}

	@Override
	public Integer sumPersonIn(String orgCode, Long projectId) {
		StatisticsDto statisticsDto = new StatisticsDto();
		statisticsDto.setOrgCode(orgCode);
		statisticsDto.setProjectId(projectId);
		return statisticsMapper.inPersonCount(statisticsDto, false, null, false);
	}

	@Override
	public void initWs(String orgCodeParam, String businessType) {
		log.info(" init ws doing orgCodeParam: {}, businessType:{}", orgCodeParam, businessType);
		if (Constant.WS_ZERO.equals(orgCodeParam)) {
			// orgCode为0时,给所有通道推送
			webSocketStatistics.sendMessageAll(businessType);
		} else {
			// orgCode自身和他的上级推送
			webSocketStatistics.sendMessageParentAndOrgCode(orgCodeParam, businessType);
		}
	}

	@Override
	public String queryStatisticsData(String orgCodeParam, String businessType) {
		long start = System.currentTimeMillis();
		Map map = new HashMap();
		CommonPageableDto pageable = new CommonPageableDto(0);
		pageable.setPageNumber(1);
		pageable.setPageSize(10);
		String orgCode = null;
		if (orgCodeParam != null && !"null".equals(orgCodeParam) && !"".equals(orgCodeParam)) {
			orgCode = orgCodeParam;
		}
		// 开启多线程查询统计数据
		Future<String> firstStatistis = this.firstStatistis(orgCode, null, map, businessType, pageable);
		Future<String> secondStatistic = this.secondStatistic(orgCode, null, map, businessType, pageable);
		Future<String> mapStatistic = this.mapStatistic(orgCode, null, map, businessType);
		if (firstStatistis.isDone() && secondStatistic.isDone() && mapStatistic.isDone()) {
			long end = System.currentTimeMillis();
			log.info(" 统计时间 ： {}", (end - start));
			return JSONObject.toJSONString(map);
		}
		long end = System.currentTimeMillis();
		log.info(" 统计时间 ： {}", (end - start));
		return null;
	}

	@Override
	public String queryStatisticsDataByProjectId(String orgCodeParam, Long projectId) {
		long start = System.currentTimeMillis();
		Map map = new HashMap();
		CommonPageableDto pageable = new CommonPageableDto(0);
		pageable.setPageNumber(1);
		pageable.setPageSize(10);
		String orgCode = null;
		if (orgCodeParam != null && !"null".equals(orgCodeParam) && !"".equals(orgCodeParam)) {
			orgCode = orgCodeParam;
		}
		// 开启多线程查询统计数据
		Future<String> firstStatistis = this.firstStatistis(orgCode, projectId, map, Constant.WS_ALL, pageable);
		Future<String> secondStatistic = this.secondStatistic(orgCode, projectId, map, Constant.WS_ALL, pageable);
		Future<String> mapStatistic = this.mapStatistic(orgCode, projectId, map, Constant.WS_ALL);
		if (firstStatistis.isDone() && secondStatistic.isDone() && mapStatistic.isDone()) {
			long end = System.currentTimeMillis();
			log.info(" 统计时间 ： {}", (end - start));
			return JSONObject.toJSONString(map);
		}
		long end = System.currentTimeMillis();
		log.info(" 统计时间 ： {}", (end - start));
		return null;
	}

	/**
	 * 综合统计
	 *
	 * @param orgCode
	 * @return
	 */
	public Object composite(String orgCode, Long projectId) {
		try {
			Map<String, Object> map = new HashMap();
			map.put("projectNum", Constant.ZERO); // 在建项目
			map.put("companyNum", Constant.ZERO); // 分包商
			map.put("inNum", Constant.ZERO); // 入场人数
			map.put("activityNum", Constant.ZERO); // 作业活动
			// 1在建项目
			LambdaQueryWrapper<Project> projectWrapper = new LambdaQueryWrapper<Project>().in(Project::getStatus, "在建",
					"开发", "策划");
			if (StringUtils.isNotEmpty(orgCode)) {
				projectWrapper = projectWrapper.likeRight(Project::getOrgCode, orgCode);
			}
			if (projectId != null) {
				projectWrapper = projectWrapper.eq(Project::getId, projectId);
			}
			int projectCount = projectService.count(projectWrapper);
			map.put("projectNum", projectCount);
			// 2分包商
			BadCompanyVo badCompanyVo = new BadCompanyVo();
			badCompanyVo.setOrgCode(orgCode);
			badCompanyVo.setProjectId(projectId);
			IPage<BadCompanyVo> badPage = companyService.pageBadCompany(true, true, new CommonPageableDto(1),
					badCompanyVo);
			List<BadCompanyVo> badCompany = badPage.getRecords();
			if (StringUtil.isNotEmpty(badCompany)) {
				map.put("companyNum", badCompany.size());
			}
			// 3入场人数
			Integer sum = this.sumPersonIn(orgCode, projectId);
			if (sum != null) {
				map.put("inNum", sum);
			}
			// 4作业活动
			Integer taskTotal = taskService.sumTotal(orgCode, projectId);
			if (taskTotal != null) {
				map.put("activityNum", taskTotal); // 作业活动
			}
			return map;
		} catch (Exception e) {
			return CommonResponseUtil.failure(e.getMessage());
		}
	}

	@Override
	public IPage<WorkActivityVo> workActivityPageInfo(WorkActivityVo workActivityVo, CommonPageableDto pageable) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		Page<WorkActivityVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		IPage<WorkActivityVo> pageData = statisticsMapper.workActivityPageInfo(page, workActivityVo);
		List<WorkActivityVo> records = pageData.getRecords();
		if (pageData.getTotal() > 0) {
			for (WorkActivityVo record : records) {
				record.setTypeValue(TaskTypeEnum.getLabelByValue(Long.valueOf(record.getType())));
				record.setStatusValue(TaskStatusEnum.getNameByType(Long.valueOf(record.getStatus())));
			}
		}
		return pageData;
	}

	/**
	 * 安全监控大屏 异步线程统计
	 *
	 * @param orgCode
	 * @param projectId
	 * @param map
	 * @return
	 */
	@Async("asyncServiceExecutor")
	public Future<String> firstStatistis(String orgCode, Long projectId, Map map, String businessType,
			CommonPageableDto pageable) {
		// 1反违章统计
		if (Constant.WS_VIOLATIONSUM.equals(businessType) || Constant.WS_ALL.equals(businessType)
				|| Constant.WS_ZERO.equals(orgCode)) {
			List<Object> list = badManagementService.violationSum(orgCode, projectId);
			map.put(Constant.WS_VIOLATIONSUM, list);
		}
		// 2综合统计
		if (Constant.WS_COMPOSITESUM.equals(businessType) || Constant.WS_ALL.equals(businessType)
				|| Constant.WS_ZERO.equals(orgCode)) {
			map.put(Constant.WS_COMPOSITESUM, composite(orgCode, projectId));
		}
		return new AsyncResult<>("");
	}

	/**
	 * 安全监控大屏 异步线程统计
	 *
	 * @param orgCode
	 * @param projectId
	 * @param map
	 * @param businessType
	 * @return
	 */
	@Async("asyncServiceExecutor")
	public Future<String> secondStatistic(String orgCode, Long projectId, Map map, String businessType,
			CommonPageableDto pageable) {
		// 3违章排名
		if (Constant.WS_VIOLATIONRANK.equals(businessType) || Constant.WS_ALL.equals(businessType)
				|| Constant.WS_ZERO.equals(orgCode)) {
			map.put(Constant.WS_VIOLATIONRANK, taskService.violationRank(pageable, "num", "desc", orgCode, projectId));
		}
		// 4分包商违章排名
		if (Constant.WS_FBSVIOLATIONRANK.equals(businessType) || Constant.WS_ALL.equals(businessType)
				|| Constant.WS_ZERO.equals(orgCode)) {
			BadCompanyVo badCompanyVo = new BadCompanyVo();
			badCompanyVo.setOrgCode(orgCode);
			badCompanyVo.setScaleOrder(false);
			badCompanyVo.setProjectId(projectId);
			map.put(Constant.WS_FBSVIOLATIONRANK, companyService.pageBadCompany(true, false, pageable, badCompanyVo));
		}
		// 5风险作业
		if (Constant.WS_RISKSUM.equals(businessType) || Constant.WS_ALL.equals(businessType)
				|| Constant.WS_ZERO.equals(orgCode)) {
			TaskRiskControlVo taskRiskControlVo = new TaskRiskControlVo();
			taskRiskControlVo.setProjectId(projectId);
			map.put(Constant.WS_RISKSUM,
					iTaskRiskControlService.riskWorkPageInfo(pageable, orgCode, 0, taskRiskControlVo));
		}
		// 6红绿码
		if (Constant.WS_REDORGREENCODE.equals(businessType) || Constant.WS_ALL.equals(businessType)
				|| Constant.WS_ZERO.equals(orgCode)) {
			map.put(Constant.WS_REDORGREENCODE, personService.personSituational(projectId, null, orgCode));
		}
		// 8风险管控屏幕 风险作业信息统计 进行中 已完成
		if (Constant.WS_RISKSTATUS.equals(businessType) || Constant.WS_ALL.equals(businessType)
				|| Constant.WS_ZERO.equals(orgCode)) {
			map.put(Constant.WS_RISKSTATUS, taskService.riskStatus(orgCode, projectId));
		}
		// 9违章管理 屏幕 今日违章
		if (Constant.WS_DAYVIOLATION.equals(businessType) || Constant.WS_ALL.equals(businessType)
				|| Constant.WS_ZERO.equals(orgCode)) {
			// 反违章数量
			List<Map<String, Object>> lists = new ArrayList<Map<String, Object>>();
			Integer num1 = rewardService.dayCountByOrgCode(orgCode, projectId);
			Map<String, Object> mapNum = new HashMap<String, Object>();
			mapNum.put("name", "反违章数量");
			mapNum.put("num", num1 == null ? '0' : num1);
			lists.add(mapNum);
			// 违章人员
			Integer num2 = retributionService.dayCountByOrgCode(orgCode, projectId);
			mapNum = new HashMap<String, Object>();
			mapNum.put("name", "违章人员");
			mapNum.put("num", num2 == null ? '0' : num2);
			lists.add(mapNum);
			// 违章分包商
			Integer num3 = retributionService.dayCompanyCountByOrgCode(orgCode, projectId);
			mapNum = new HashMap<String, Object>();
			mapNum.put("name", "违章分包商");
			mapNum.put("num", num3 == null ? '0' : num3);
			lists.add(mapNum);
			map.put(Constant.WS_DAYVIOLATION, lists);
		}
		return new AsyncResult<>("");
	}

	/**
	 * 安全监控大屏地图数据统计
	 *
	 * @param orgCode
	 * @param projectId
	 * @param map
	 * @return
	 */
	@Async("asyncServiceExecutor")
	public Future<String> mapStatistic(String orgCode, Long projectId, Map map, String businessType) {
		// 7地图 项目点
		try {
			if (Constant.WS_MAPPROJECTSUM.equals(businessType) || Constant.WS_ALL.equals(businessType)
					|| Constant.WS_ZERO.equals(orgCode)) {
				map.put(Constant.WS_MAPPROJECTSUM, projectService.getMapLine(orgCode, projectId));
			}
		} catch (Exception e) {
			log.info("地图 项目点 fail");
		}
		return new AsyncResult<>("");
	}
	

}
