package com.yeejoin.precontrol.common.vo;

import java.util.Date;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 考试记录表
 *
 * @author duanwei
 * @date 2021-02-23
 */
@Data
public class PersonExamRecordVo {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "考试id")
    private Long examId;

    @ApiModelProperty(value = "考试名称")
    private String examName;

    @ApiModelProperty(value = "userid")
    private Long userId;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "分数")
    private Integer score;

    @ApiModelProperty(value = "通过")
    private Integer qualified;

    @ApiModelProperty(value = "考试开始时间")
    private Date examStartTime;

    @ApiModelProperty(value = "考试结束时间")
    private Date examEndTime;

    @ApiModelProperty(value = "机构ID")
    private String orgCode;

    @ApiModelProperty(value = "人员名称")
    private String personName;
}
