package com.yeejoin.precontrol.common.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.TaskPerson;
import com.yeejoin.precontrol.common.entity.TaskRiskWorkMeasureResult;
import com.yeejoin.precontrol.common.param.RiskWorkParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 风险管控任务表Vo
 *
 * @author duanwei
 * @date 2021-01-28
 */
@Data
public class TaskRiskControlDetailVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 风险管控名称
     */
    @ApiModelProperty(value = "风险管控名称")
    private String name;

    /**
     * 级别
     */
    private String level;

    /**
     * 级别描述
     */
    private String levelName;
    /**
     * 项目id
     */
    @ApiModelProperty(value = "项目id")
    private Long projectId;

    /**
     * 风险作业id
     */
    @ApiModelProperty(value = "风险作业id")
    private Long riskWorkId;
    /**
     * 计划开始时间
     */
    @ApiModelProperty(value = "计划开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startTime;
    /**
     * 计划结束时间
     */
    @ApiModelProperty(value = "计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endTime;
    @ApiModelProperty(value = "提前启动时间")
    /**
     * 提前启动时间
     */
    private Integer preStartTime;
    /**
     * 任务id
     */
    @ApiModelProperty(value = "任务id")
    private Long taskId;
    /**
     * 阶段
     */
    @ApiModelProperty(value = "阶段")
    private Integer stage;
    /**
     * 公司id
     */
    @ApiModelProperty(value = "公司id")
    private Long companyId;
    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 施工负责人id
     */
    @ApiModelProperty(value = "公司负责人id")
    private Long constructionPersonId;

    /**
     * 施工负责人name
     */
    private String constructionPersonName;

    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 项目地址
     */
    private String projectAddress;

    /**
     * 安全负责人id
     */
    @ApiModelProperty(value = "安全负责人id")
    private Long secPersonId;

    /**
     * 安全负责人name
     */
    private String secPersonName;
    /**
     * 状态code
     */
    private String status;
    /**
     * 状态描述
     */
    private String statusValue;

}