package com.yeejoin.precontrol.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.ProjectCompanyFilling;
import com.yeejoin.precontrol.common.service.IProjectCompanyFillingService;
import com.yeejoin.precontrol.common.utils.FileHelper;
import com.yeejoin.precontrol.common.vo.ProjectCompanyFillingExcelVo;
import com.yeejoin.precontrol.common.vo.ProjectCompanyFillingVo;
import com.yeejoin.precontrol.common.vo.TaskPageVo;
import com.yeejoin.precontrol.controller.publics.BaseController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 项目关联分包商表
 *
 * @author duanwei
 * @date 2022-06-08
 */
@RestController
@Api(tags = "项目关联分包商表Api")
@RequestMapping(value = "/project-company-filling", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ProjectCompanyFillingController extends BaseController {

	@Autowired
	IProjectCompanyFillingService iProjectCompanyFillingService;

	/**
	 * 新增项目关联分包商表
	 * 
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增项目关联分包商表", notes = "新增项目关联分包商表")
	public boolean saveProjectCompanyFilling(HttpServletRequest request,
			@RequestBody List<ProjectCompanyFillingVo> projectCompanyFillings) {
		Person person = getPerson();
		return iProjectCompanyFillingService.save(projectCompanyFillings, person.getId());
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iProjectCompanyFillingService.removeById(id);
	}

	/**
	 * 修改项目关联分包商表
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "修改项目关联分包商表", notes = "修改项目关联分包商表")
	public boolean updateByIdProjectCompanyFilling(HttpServletRequest request,
			@RequestBody ProjectCompanyFilling projectCompanyFilling) {
		return iProjectCompanyFillingService.updateById(projectCompanyFilling);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public ProjectCompanyFilling selectById(HttpServletRequest request, @PathVariable Long id) {
		return iProjectCompanyFillingService.getById(id);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public List<ProjectCompanyFillingVo> listPage( HttpServletResponse response,String orgCode, @DateTimeFormat(pattern = "yyyy-MM") Date startMonth,
			@DateTimeFormat(pattern = "yyyy-MM") Date endMonth, int operType,ProjectCompanyFillingVo projectCompanyFillingVo) {
		if(StringUtils.isEmpty(orgCode)) 
		{
			orgCode=null;
		}
		List<ProjectCompanyFillingVo> list = iProjectCompanyFillingService.list(orgCode, startMonth, endMonth,projectCompanyFillingVo);
		String name = "数据填报" + startMonth + "-" + endMonth;
		String fileName = UUID.randomUUID().toString() + ".xls";
		if (operType == 1) {
			FileHelper.exportExcel(list, name, name, ProjectCompanyFillingVo.class, fileName, response);
			return null;
		}else 
		{
			return list;
		}
	
	}
}
