package com.yeejoin.precontrol.controller;

/**
 * 统计-HR
 *
 * @author sqy
 */

import java.io.IOException;
import java.util.Date;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.entity.ReportStatictisRecord;
import com.yeejoin.precontrol.common.enums.WordTemplateTypeEum;
import com.yeejoin.precontrol.common.service.IProjectService;
import com.yeejoin.precontrol.common.service.IReportStatictisRecordService;
import com.yeejoin.precontrol.common.service.IStatisticalHRService;
import com.yeejoin.precontrol.common.utils.DateUtils;
import com.yeejoin.precontrol.common.utils.WordTemplateUtils;
import com.yeejoin.precontrol.common.vo.PersonClockVo;
import com.yeejoin.precontrol.common.vo.ProjectClockVo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

@RestController
@Api(tags = "统计api-HR")
@RequestMapping(value = "/statisticalHR", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Slf4j
public class StatisticalHRController {

	@Autowired
	IProjectService iProjectService;

	@Autowired
	IStatisticalHRService iStatisticalHRService;

	@Autowired
	IReportStatictisRecordService iReportStatictisRecordService;

	@Value("${statictis.hour}")
	private int statictisHour;

	@RequestMapping(value = "/worker/export", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "农名工统计", notes = "农名工统计")
	public void exportWorker(HttpServletRequest request, HttpServletResponse response, String orgCode,
			@DateTimeFormat(pattern = "yyyy-MM") Date startMonth, @DateTimeFormat(pattern = "yyyy-MM") Date endMonth) {
		WordTemplateUtils instance = WordTemplateUtils.getInstance();
		if (StringUtils.isEmpty(orgCode)) {
			orgCode = null;
		}
		String ftlFile = WordTemplateTypeEum.worker_report_general.getTemplateFile();
		if (orgCode != null) {
			ftlFile = WordTemplateTypeEum.worker_report_project.getTemplateFile();
		}

		Map<String, Object> map = iStatisticalHRService.getMap(orgCode, startMonth, endMonth);
		try {
			instance.exportMillCertificateExcel(request, response, map, orgCode, ftlFile);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	@RequestMapping(value = "/worker-salary/export", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "农名工统计", notes = "农名工统计")
	public void exportWorkerSalary(HttpServletRequest request, HttpServletResponse response, String orgCode,
			@DateTimeFormat(pattern = "yyyy-MM") Date startMonth, @DateTimeFormat(pattern = "yyyy-MM") Date endMonth) {
		WordTemplateUtils instance = WordTemplateUtils.getInstance();
		if (StringUtils.isEmpty(orgCode)) {
			orgCode = null;
		}
		String ftlFile = WordTemplateTypeEum.worker_report_salary_general.getTemplateFile();
		if (orgCode != null) {
			ftlFile = WordTemplateTypeEum.worker_report_salary_project.getTemplateFile();
		}

		Map<String, Object> map = iStatisticalHRService.getSalaryMap(orgCode, startMonth, endMonth);
		try {
			instance.exportMillCertificateExcel(request, response, map, orgCode, ftlFile);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	@RequestMapping(value = "/worker", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "农名工统计", notes = "农名工统计")
	public Object exportWorker(String orgCode, @DateTimeFormat(pattern = "yyyy-MM") Date startMonth,
			@DateTimeFormat(pattern = "yyyy-MM") Date endMonth) {
		if (StringUtils.isEmpty(orgCode)) {
			orgCode = null;
		}
		if (orgCode == null) {
			ReportStatictisRecord reportStatictisRecord = iReportStatictisRecordService.getOne(
					new LambdaQueryWrapper<ReportStatictisRecord>().eq(ReportStatictisRecord::getStartMonth, startMonth)
							.eq(ReportStatictisRecord::getEndMonth, endMonth).eq(ReportStatictisRecord::getType, 0));
			if (reportStatictisRecord == null) {
				ReportStatictisRecord newReportStatictisRecord = new ReportStatictisRecord();
				newReportStatictisRecord.setStartMonth(startMonth);
				newReportStatictisRecord.setEndMonth(endMonth);
				newReportStatictisRecord.setType(0);
				iReportStatictisRecordService.save(newReportStatictisRecord);
				new Thread(new Runnable() {
					@Override
					public void run() {
						Map<String, Object> map = iStatisticalHRService.getMap(null, startMonth, endMonth);
						newReportStatictisRecord.setJson(JSONObject.toJSONString(map));
						iReportStatictisRecordService.updateById(newReportStatictisRecord);
					}
				}).start();
				return 0;
			}
			if (reportStatictisRecord.getJson() != null) {
				// 如果超时重新算
				if (DateUtils.dateAddHours(reportStatictisRecord.getUpdateTime(), statictisHour).before(new Date())) {
					reportStatictisRecord.setJson(null);
					iReportStatictisRecordService.updateById(reportStatictisRecord);
					new Thread(new Runnable() {
						@Override
						public void run() {
							Map<String, Object> map = iStatisticalHRService.getMap(null, startMonth, endMonth);
							reportStatictisRecord.setJson(JSONObject.toJSONString(map));
							iReportStatictisRecordService.updateById(reportStatictisRecord);
						}
					}).start();
					return 0;
				} else {
					return JSONObject.parse(reportStatictisRecord.getJson());
				}
			} else {
				return 0;
			}
		} else {
			Map<String, Object> map = iStatisticalHRService.getMap(orgCode, startMonth, endMonth);
			return map;
		}
	}

	@RequestMapping(value = "/worker-salary", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "农名工统计", notes = "农名工统计")
	public Object exportWorkerSalary(String orgCode, @DateTimeFormat(pattern = "yyyy-MM") Date startMonth,
			@DateTimeFormat(pattern = "yyyy-MM") Date endMonth) {
		if (StringUtils.isEmpty(orgCode)) {
			orgCode = null;
		}
		if (orgCode == null) {
			ReportStatictisRecord reportStatictisRecord = iReportStatictisRecordService.getOne(
					new LambdaQueryWrapper<ReportStatictisRecord>().eq(ReportStatictisRecord::getStartMonth, startMonth)
							.eq(ReportStatictisRecord::getEndMonth, endMonth).eq(ReportStatictisRecord::getType, 1));
			if (reportStatictisRecord == null) {
				ReportStatictisRecord newReportStatictisRecord = new ReportStatictisRecord();
				newReportStatictisRecord.setStartMonth(startMonth);
				newReportStatictisRecord.setEndMonth(endMonth);
				newReportStatictisRecord.setType(1);
				iReportStatictisRecordService.save(newReportStatictisRecord);
				new Thread(new Runnable() {
					@Override
					public void run() {
						Map<String, Object> map = iStatisticalHRService.getSalaryMap(null, startMonth, endMonth);
						newReportStatictisRecord.setJson(JSONObject.toJSONString(map));
						iReportStatictisRecordService.updateById(newReportStatictisRecord);
					}
				}).start();
				return 0;
			}
			if (reportStatictisRecord.getJson() != null) {
				// 如果超时重新算
				if (DateUtils.dateAddHours(reportStatictisRecord.getUpdateTime(), statictisHour).before(new Date())) {
					reportStatictisRecord.setJson(null);
					iReportStatictisRecordService.updateById(reportStatictisRecord);
					new Thread(new Runnable() {
						@Override
						public void run() {
							Map<String, Object> map = iStatisticalHRService.getMap(null, startMonth, endMonth);
							reportStatictisRecord.setJson(JSONObject.toJSONString(map));
							iReportStatictisRecordService.updateById(reportStatictisRecord);
						}
					}).start();
					return 0;
				} else {
					return JSONObject.parse(reportStatictisRecord.getJson());
				}
			} else {
				return 0;
			}
		} else {
			Map<String, Object> map = iStatisticalHRService.getSalaryMap(orgCode, startMonth, endMonth);
			return map;
		}
	}

	/**
	 * 本月统计
	 *
	 * @return
	 */
	@RequestMapping(value = "/personStatistics", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "本月统计", notes = "本月统计")
	public Object personStatistics(String orgCode, @DateTimeFormat(pattern = "yyyy-MM") Date startMonth,
			@DateTimeFormat(pattern = "yyyy-MM") Date endMonth) {
		if (StringUtils.isEmpty(orgCode)) {
			orgCode = null;
		}
		return iStatisticalHRService.personStatistics(orgCode, startMonth, endMonth);
	}

	/**
	 * 项目信息
	 *
	 * @return
	 */
	@RequestMapping(value = "/projectStatistics", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "本月统计", notes = "本月统计")
	public Object projectStatistics(String orgCode, @DateTimeFormat(pattern = "yyyy-MM") Date startMonth,
			@DateTimeFormat(pattern = "yyyy-MM") Date endMonth) {
		if (StringUtils.isEmpty(orgCode)) {
			orgCode = null;
		}
		return iStatisticalHRService.projectStatistics(orgCode, startMonth, endMonth);
	}

	/**
	 * 上岗人员
	 *
	 * @return
	 */
	@RequestMapping(value = "/duty/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "本月统计", notes = "本月统计")
	public Object dutyList(CommonPageableDto pageable, ProjectClockVo projectClockVo) {
		if (StringUtils.isEmpty(projectClockVo.getOrgCode())) {
			projectClockVo.setOrgCode(null);
		}
		return iStatisticalHRService.dutyList(pageable, projectClockVo);
	}

	/**
	 * 入场人员
	 *
	 * @return
	 */
	@RequestMapping(value = "/enter/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "本月统计", notes = "本月统计")
	public Object enterList(CommonPageableDto pageable, PersonClockVo personClockVo) {
		if (StringUtils.isEmpty(personClockVo.getOrgCode())) {
			personClockVo.setOrgCode(null);
		}
		return iStatisticalHRService.enterList(pageable, personClockVo);
	}
}
