package com.yeejoin.amos.boot.module.tzs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 消息流水表
 *
 * @author system_generator
 * @date 2022-04-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "MsgLogDto", description = "消息流水表")
public class MsgLogDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "关联编号")
    private String relationCode;

    @ApiModelProperty(value = "消息类型（超期预警、许可超期、风险预警）")
    private String msgType;

    @ApiModelProperty(value = "消息类型名称")
    private String msgTypeName;

    @ApiModelProperty(value = "消息内容")
    private String body;

    @ApiModelProperty(value = "接收者账号")
    private String targetCode;

    @ApiModelProperty(value = "接收者名称")
    private String targetName;

    @ApiModelProperty(value = "发送日期")
    private Date sendTime;

    @ApiModelProperty(value = "站端类型： WEB,APP")
    private String terminalType;

    @ApiModelProperty(value = "是否已读")
    private Boolean isRead = false;
}
