package com.yeejoin.amos.boot.module.tzs.flc.api.dto;

import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
/**
* 液化气体气瓶充装信息-充装记录Dto
*
* @author duanwei
* @date 2022-08-11
*/
@Data
public class TzCylinderFillingDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    /**
     * id
     */
    private String sequenceNbr;

    /**
     * 充装量
     */
    private String fillingQuantity;

    /**
     * 气瓶唯一标识编码
     */
    private String sequenceCode;

    /**
     * 气瓶充装前检查id
     */
    private String fillingBeforeId;

    /**
     * 气瓶充装后检查id
     */
    private String fillingCheckId;

    @ApiModelProperty(value = "充装记录Id")
    /**
     * 充装记录Id
     */
    private String fillingRecordId;
    @ApiModelProperty(value = "充装开始时间")
    /**
     * 充装开始时间
     */
    private String fillingStarttime;
    @ApiModelProperty(value = "充装结束时间")
    /**
     * 充装结束时间
     */
    private String fillingEndtime;
    @ApiModelProperty(value = "充装人员姓名")
    /**
     * 充装人员姓名
     */
    private String fillingUser;
    @ApiModelProperty(value = "不能与充装人员姓名相同")
    /**
     * 不能与充装人员姓名相同
     */
    private String inspectorName;
    @ApiModelProperty(value = "室温")
    /**
     * 室温
     */
    private Double temperature;
    @ApiModelProperty(value = "异常情况")
    /**
     * 异常情况
     */
    private Integer abnormal;

    /**
     * 充装前检查结果
     */
    private String checkResultsBefore;

    /**
     * 充装后检查结果
     */
    private String checkResultsAfter;

    /**
     * 充装前检查项内容及结果
     */
    private List<TzCylinderCheckDto> tzCylinderCheckDtoList;

    /**
     * 充装后检查项内容及结果
     */
    private List<TzCylinderCheckDto> tzCylinderAfterCheckDtoList;

    /**
     * 充装前检查人员
     */
    private String inspectorBeforeUser;

    /**
     * 充装前检查时间
     */
    private String inspectionBeforeDate;

    /**
     * 充装后检查时间
     */
    private String inspectionAfterDate;

    /**
     * 充装后检查人员
     */
    private String inspectorAfter;



}
