package com.yeejoin.amos.boot.module.ugp.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author cpp
 * @Description    检验检测阶段
 * @Date 2022/10/17
 */
@Getter
@AllArgsConstructor
public enum  StageEnum {

    焊前人员("人员确定","STAFF","人员","人员校验"),
    焊前设备("设备确定","EQUIPMENT","设备","设备校验"),
    焊前管材质量("管材确定","BEFORE-WELDING","管材","管材校验"),
    焊接工艺("工艺确定","CRAFT","工艺","工艺校验"),
    管道耐压("耐压确定","VOLTAGE","耐压","耐压校验"),
    敷设质量("敷设确定","LAY","敷设","敷设校验"),
    定位("定位确定","LOTCATION","定位","定位校验"),
    回填("回填确定","BACKFILL","回填","回填校验");

    private String name;
    private String stage;
    private String verifyName;
    private String detailVerifyName;





    public static Map<String,String> getStageByNameMap = new HashMap<>();
    public static Map<String,String> getStatusByVerifyNameMap = new HashMap<>();
    public static Map<String,String> getDetailVerifyNameMap = new HashMap<>();
    static {
        for(StageEnum enums:StageEnum.values()){
            getStageByNameMap.put(enums.stage,enums.name);
            getStatusByVerifyNameMap.put(enums.stage, enums.verifyName);
            getDetailVerifyNameMap.put(enums.verifyName, enums.detailVerifyName);
        }
    }




}