package com.yeejoin.amos.boot.module.ugp.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 项目信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_ugp_project")
public class Project extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 项目名称
     */
    @TableField("name")
    private String name;

    /**
     * 项目编号
     */
    @TableField("code")
    private String code;

    /**
     * 项目进度
     */
    @TableField("progress_status")
    private String progressStatus;

    /**
     * 项目地点
     */
    @TableField("address")
    private String address;

    /**
     * 项目开工日期
     */
    @TableField("start_date")
    private Date startDate;

    /**
     * 项目安装区域代码
     */
    @TableField("install_region_code")
    private String installRegionCode;

    /**
     * 项目安装区域
     */
    @TableField("install_region")
    private String installRegion;

    /**
     * 建设单位id
     */
    @TableField("construction_unit_id")
    private Long constructionUnitId;

    /**
     * 建设单位名称
     */
    @TableField("construction_unit")
    private String constructionUnit;

    /**
     * 项目设计单位
     */
    @TableField("design_unit")
    private String designUnit;

    /**
     * 项目设计单位id
     */
    @TableField("design_unit_id")
    private Long designUnitId;

    /**
     * 安装单位id
     */
    @TableField("installation_unit_id")
    private Long installationUnitId;

    /**
     * 安装单位名称
     */
    @TableField("installation_unit")
    private String installationUnit;

    /**
     * 企业id
     */
    @TableField("company_id")
    private Long companyId;

    /**
     * 建设单位负责人id
     */
    @TableField("charge_person_id")
    private Long chargePersonId;

    /**
     * 建设单位负责人名称
     */
    @TableField("charge_person")
    private String chargePerson;

    /**
     * 组织机构代码
     */
    @TableField("org_code")
    private String orgCode;

    /**
     * 项目提交日期
     */
    @TableField("submit_date")
    private Date submitDate;

    /**
     * 流程id
     */
    @TableField("instance_id")
    private String instanceId;

    /**
     * 流程状态
     */
    @TableField("status")
    private String status;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 长度
     */
    @TableField("length")
    private String length;

    /**
     * 组织机构代码
     */
    @TableField("credit_code")
    private String creditCode;
}
