package com.yeejoin.amos.boot.module.ugp.biz.controller;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.ugp.api.entity.UnitLicence;
import com.yeejoin.amos.boot.module.ugp.api.service.IUnitLicenceService;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RestController;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.Arrays;


/**
 * 单位许可信息表
 *
 * @author duanwei
 * @date 2022-11-30
 */
@RestController
@Api(tags = "单位许可信息表Api")
@RequestMapping(value = "/tz-ugp-unit-licence", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class UnitLicenceController {

  @Autowired
  IUnitLicenceService iUnitLicenceService;


    /**
    * 新增单位许可信息表
    * @return
    */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增单位许可信息表", notes = "新增单位许可信息表")
    public boolean saveTzUgpUnitLicence(HttpServletRequest request, @RequestBody UnitLicence unitLicence){
    return iUnitLicenceService.save(unitLicence);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
    return iUnitLicenceService.removeById(id);
    }




    /**
    * 修改单位许可信息表
    * @return
    */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改单位许可信息表", notes = "修改单位许可信息表")
    public boolean updateByIdTzUgpUnitLicence(HttpServletRequest request, @RequestBody UnitLicence unitLicence){
    return iUnitLicenceService.updateById(unitLicence);
    }



    /**
   * 根据id查询
   * @param id
   * @return
   */
   @RequestMapping(value = "/{id}", method = RequestMethod.GET)
   @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
   public UnitLicence selectById(HttpServletRequest request, @PathVariable Long id){
      return iUnitLicenceService.getById(id);
   }



  /**
  * 列表分页查询
  * @return
  */
  @RequestMapping(value = "/list", method = RequestMethod.GET)
  @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
  public IPage<UnitLicence> listPage(String pageNum, String pageSize,
                                     UnitLicence unitLicence){

    Page<UnitLicence> pageBean;
    QueryWrapper<UnitLicence> tzUgpUnitLicenceQueryWrapper = new QueryWrapper<>();
    Class<? extends UnitLicence> aClass = unitLicence.getClass();
    Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
        try {
            field.setAccessible(true);
            Object o = field.get(unitLicence);
            if (o != null) {
                Class<?> type = field.getType();
                String name = NameUtils.camel2Underline(field.getName());
                if (type.equals(Integer.class)) {
                Integer fileValue = (Integer) field.get(unitLicence);
                tzUgpUnitLicenceQueryWrapper.eq(name, fileValue);
                } else if (type.equals(Long.class)) {
                Long fileValue = (Long) field.get(unitLicence);
                tzUgpUnitLicenceQueryWrapper.eq(name, fileValue);
                } else if (type.equals(String.class)) {
                String fileValue = (String) field.get(unitLicence);
                tzUgpUnitLicenceQueryWrapper.eq(name, fileValue);
                } else {
                String fileValue = (String) field.get(unitLicence);
                tzUgpUnitLicenceQueryWrapper.eq(name, fileValue);
            }
          }
        }catch (Exception e) {
        }
    });
    IPage<UnitLicence> page;
    if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
        pageBean = new Page<>(0, Long.MAX_VALUE);
    }else{
        pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
    }
    page = iUnitLicenceService.page(pageBean, tzUgpUnitLicenceQueryWrapper);
    return page;
  }
}


