package com.yeejoin.amos.boot.module.ugp.biz.fegin;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * 数据集成服务接口feign
 *
 * @author Dell
 */
@FeignClient(name = "${maas.feign.name:maas-mdm}", path = "maas", configuration =
		{MultipartSupportConfig.class})
public interface MaasServiceFeignClient {

	String ocrServiceId = "0a456d67-5e12-48af-8923-ccc447d4cb2b";

	/**
	 * 获取图片识别数据
	 *
	 * @param param
	 * @return
	 */
	@RequestMapping(value = "/maas/processes/api/" + ocrServiceId, method = RequestMethod.POST)
	ResponseModel<Object> getPatrolDangerInfo(@RequestBody Object param);

}
