package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.ugp.api.Enum.OrgEnum;
import com.yeejoin.amos.boot.module.ugp.api.entity.Attachment;
import com.yeejoin.amos.boot.module.ugp.api.mapper.AttachmentMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IAttachmentService;
import com.yeejoin.amos.boot.module.ugp.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import org.apache.commons.lang.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.ugp.biz.controller.ProjectController;


/**
 * 附件表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class AttachmentServiceImpl extends BaseService<AttachmentDto,Attachment,AttachmentMapper> implements IAttachmentService {
    @Autowired
    OrgServiceImpl orgServiceImpl;

    @Autowired
    OrgUsrServiceImpl orgUsrService;
    @Autowired
    private AttachmentMapper attachmentMapper;
    /**
     * 分页查询
     */
    public Page<AttachmentDto> queryForAttachmentPage(Page<AttachmentDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<AttachmentDto> queryForAttachmentList()   {
        return this.queryForList("" , false);
    }

    /**
     * 根据sourceId添加附件
     * @param subForm
     * @param sequenceNbr
     *
     */
    public void saveAttachment(JSONArray subForm, Long sequenceNbr){
        Attachment attachment = new Attachment();
        attachment.setSourceId(sequenceNbr);
        attachment.setInfo(JSON.toJSONString(subForm));
        for(Object o:subForm){
            JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(o));
            jsonObject.getString("Symbol_key");
            JSONArray jsonArray = jsonObject.getJSONArray("info");
            if(!ValidationUtil.isEmpty(jsonArray)) {
                for (Object j : jsonArray) {
                    JSONObject info = JSON.parseObject(JSON.toJSONString(j));
                    String name = info.getString("name");
                    attachment.setName(info.getString("name"));
                    attachment.setType(name.substring(name.lastIndexOf(".") + 1));
                    break;
                }
            }
        }
        this.save(attachment);
    }


    /**
     *获取登录人的单位
     *
     */
    @BusinessIdentify
    public Map selectUnit(){
        Map map = new HashMap<>();
        //获取登录人的redis信息
        ReginParams reginParams = orgServiceImpl.getReginParams();
        //根据redis信息去获取登录人信息后再获取到登录人的sequenceNbr
        Long companyId = reginParams.getBusinessInfo().getCompanySequenceNbr();
        OrgUsr orgUsr = orgUsrService.getById(companyId);
        String key = orgUsr.getOrgExpandAttr1();
        map.put("type",OrgEnum.map.get(key));
        return map;
    }


    //source_id和附件类型查询数据
    public AttachmentDto getAttachment(Long sourceId){
        if (sourceId == null ) {
            return new AttachmentDto();
        }
       return attachmentMapper.getAttachment(sourceId);

    }

}