package com.yeejoin.amos.api.openapi.face.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yeejoin.amos.api.openapi.face.model.OpenapiLogModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.OpenapiLogMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.OpenapiLog;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 
 * <pre>
 * 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: OpenapiLogService.java, v 0.1 2021年11月10日 下午5:55:31 gwb Exp $
 */
@Component
public class OpenapiLogService extends BaseService<OpenapiLogModel, OpenapiLog, OpenapiLogMapper> {


	private ObjectMapper objectMapper = new ObjectMapper();
    /**
     * 分页查询
     */
    @SuppressWarnings("unchecked")
	public Page<OpenapiLogModel> queryForOpenserviceOperateLogPage(Page page, String agencyCode, @Condition(Operator.like) String methodLabel) throws Exception {
    	
    	Page<OpenapiLogModel> openserviceOperateLogModelPage = this.queryForPage(page, "CREATE_TIME", false,agencyCode, methodLabel);
    	List<OpenapiLogModel> openserviceOperateLogModelList = openserviceOperateLogModelPage.getRecords();
    	Map<String, AgencyUserModel> userMap = new HashMap<String, AgencyUserModel>();
    	for (OpenapiLogModel openserviceOperateLogModel : openserviceOperateLogModelList)
		{
    		//填充操作人信息
    		AgencyUserModel agencyUserModel = userMap.get(openserviceOperateLogModel.getRecUserId());
    		if (ValidationUtil.isEmpty(agencyUserModel))
			{
    			openserviceOperateLogModel.setUserName(openserviceOperateLogModel.getRecUserId());
				openserviceOperateLogModel.setUserRealName(openserviceOperateLogModel.getRecUserId());
    			FeignClientResult<AgencyUserModel> responseModel = Privilege.agencyUserClient.queryByUserId(openserviceOperateLogModel.getRecUserId());
    			AgencyUserModel userModel = responseModel.getResult();
    			if (!ValidationUtil.isEmpty(userModel))
				{
    				userMap.put(openserviceOperateLogModel.getRecUserId(), userModel);
    				openserviceOperateLogModel.setUserName(userModel.getUserName());
    				openserviceOperateLogModel.setUserRealName(userModel.getRealName());
				}
			}else 
			{
				openserviceOperateLogModel.setUserName(agencyUserModel.getUserName());
				openserviceOperateLogModel.setUserRealName(agencyUserModel.getRealName());
			}
    		//填充操作状态
    		String result = openserviceOperateLogModel.getResult();
			Map<String, Object> mapJson  = objectMapper.readValue(result,Map.class);
            String status = mapJson.get("status").toString();
            if (status.equals("200"))
			{
            	openserviceOperateLogModel.setResultStatus("成功");
			}else 
			{
				openserviceOperateLogModel.setResultStatus("失败");
			}
		}
    	openserviceOperateLogModelPage.setRecords(openserviceOperateLogModelList);
        return openserviceOperateLogModelPage;
    }

    /**
     * 列表查询 示例
     */
    public List<OpenapiLogModel> queryForOpenserviceOperateLogList(String agencyCode) throws Exception {
        return this.queryForList("", false, agencyCode);
    }


}
