package com.yeejoin.amos.api.householdapi.controller;

import com.yeejoin.amos.api.householdapi.face.model.HouseholdPvProducerInfoDto;
import com.yeejoin.amos.api.householdapi.face.service.impl.HouseholdPvProducerInfoServiceImpl;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 户用光伏-厂商信息表
 *
 * @author system_generator
 * @date 2023-06-07
 */
@RestController
@Api(tags = "户用光伏-厂商信息表Api")
@RequestMapping(value = "/household-pv-producer-info")
public class HouseholdPvProducerInfoController {

    @Autowired
	HouseholdPvProducerInfoServiceImpl householdPvProducerInfoServiceImpl;

    /**
     * 新增户用光伏-厂商信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增户用光伏-厂商信息表", notes = "新增户用光伏-厂商信息表")
	public ResponseModel<HouseholdPvProducerInfoDto> save(@RequestBody HouseholdPvProducerInfoDto model) {
	    model = householdPvProducerInfoServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏-厂商信息表", notes = "根据sequenceNbr更新户用光伏-厂商信息表")
	public ResponseModel<HouseholdPvProducerInfoDto> updateBySequenceNbrHouseholdPvProducerInfo(@RequestBody HouseholdPvProducerInfoDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(householdPvProducerInfoServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏-厂商信息表", notes = "根据sequenceNbr删除户用光伏-厂商信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(householdPvProducerInfoServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个户用光伏-厂商信息表",  notes = "根据sequenceNbr查询单个户用光伏-厂商信息表")
	public ResponseModel<HouseholdPvProducerInfoDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(householdPvProducerInfoServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "户用光伏-厂商信息表分页查询",  notes = "户用光伏-厂商信息表分页查询")
	public ResponseModel<Page<HouseholdPvProducerInfoDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<HouseholdPvProducerInfoDto> page = new Page<HouseholdPvProducerInfoDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(householdPvProducerInfoServiceImpl.queryForHouseholdPvProducerInfoPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "户用光伏-厂商信息表列表全部数据查询",   notes = "户用光伏-厂商信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<HouseholdPvProducerInfoDto>> selectForList() {
	    return ResponseHelper.buildResponse(householdPvProducerInfoServiceImpl.queryForHouseholdPvProducerInfoList());
	}
}
