package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import com.yeejoin.amos.api.openapi.face.orm.entity.AbstractBaseEntity;
/**
 * 安全追溯-制造信息
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("mid_equip_factory_info")
public class ProduceInfo extends AbstractEquipBaseEntity {
    private static final long serialVersionUID = 1L;



    @TableField(value ="\"SUPERVISORY_CODE\"")
    private String supervisoryCode;
    /**
     *  	 * $column.comments
     *      */


    @TableField(value ="\"INSTANCE_ID\"")
    private String instanceId;
    /**
     *  	 * $column.comments
     *      */

    @TableField(value ="\"STATUS\"")
    private String status;
    /**
     *  	 * 制造单位统一社会信用代码
     *      */

    @TableField(value ="\"PRODUCE_UNIT_CREDIT_CODE\"")
    private String produceUnitCreditCode;
    /**
     *  	 * 制造单位名称
     *      */

    @TableField(value ="\"PRODUCE_UNIT_NAME\"")
    private String produceUnitName;
    /**
     *  	 * 制造许可编号
     *      */

    @TableField(value ="\"PRODUCE_LICENSE_NUM\"")
    private String produceLicenseNum;
    /**
     *  	 * 出厂编号
     *      */

    @TableField(value ="\"FACTORY_NUM\"")
    private String factoryNum;
    /**
     *  	 * 制造日期
     *      */

    @TableField(value ="\"PRODUCE_DATE\"")
    private Date produceDate;
    /**
     *  	 * 是否进口
     *      */

    @TableField(value ="\"IMPORTED\"")
    private String imported;
    /**
     *  	 * 制造国
     *      */

    @TableField(value ="\"PRODUCE_COUNTRY\"")
    private String produceCountry;
    /**
     *  	 * 制造标准
     *      */

    @TableField(value ="\"FACTORY_STANDARD\"")
    private String factoryStandard;
    /**
     *  	 * 产品质量合格证明
     *      */

    @TableField(value ="\"PRODUCT_QUALITY_YIELD_PROVE\"")
    private String productQualityYieldProve;
    /**
     *  	 * 安装及使用维护保养说明
     *      */

    @TableField(value ="\"INS_USE_MAINTAIN_EXPLAIN\"")
    private String insUseMaintainExplain;
    /**
     *  	 * 监督检验证书
     *      */

    @TableField(value ="\"SUPERVISION_AGENCY_CREDENTIAL\"")
    private String supervisionAgencyCredential;
    /**
     *  	 * 型式试验证书
     *      */

    @TableField(value ="\"TYPE_TEST_CREDENTIAL\"")
    private String typeTestCredential;


}
