package com.yeejoin.amos.boot.module.ccs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 设备信号类型上报次数日统计
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("asf_fire_signal_day_statistics")
public class FireSignalDayStatistics extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 站点编码
     */
    @TableField("station_code")
    private String stationCode;

    /**
     * 站点名称
     */
    @TableField("station_name")
    private String stationName;

    /**
     * 统计日期
     */
    @TableField("collect_date")
    private Date collectDate;

    /**
     * 报警次数
     */
    @TableField("report_times")
    private Integer reportTimes;

    /**
     * 信号类型
     */
    @TableField("signal_type")
    private String signalType;

    /**
     * 信号类型名称
     */
    @TableField("signal_type_name")
    private String signalTypeName;

    /**
     * 是否为告警信号数据
     */
    private Boolean isAlarm;


}
