package com.yeejoin.equipmanage.common.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.common.dto
 * @ClassName: WaterResourceDto
 * @Author: Jianqiang Gao
 * @Description: WaterResourceDto
 * @Date: 2021/7/20 11:17
 * @Version: 1.0
 */
@Data
public class WaterResourceDto {

    @ApiModelProperty(value = "主键ID")
    protected Long sequenceNbr;

    @ApiModelProperty(value = "更新时间")
    protected Date recDate;

    @ApiModelProperty(value = "更新人")
    protected String recUserId;

    @ApiModelProperty(value = "是否删除")
    private Boolean isDelete;

    @ApiModelProperty(value = "资源名称")
    private String name;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "经度")
    private Double longitude;

    @ApiModelProperty(value = "纬度")
    private Double latitude;

    @ApiModelProperty(value = "资源类型（消火栓：hydrant、消防水鹤：crane、天然水源：natural、消防水池：pool）")
    private String resourceType;

    @ApiModelProperty(value = "资源类型名称（消火栓、消防水鹤、天然水源、消防水池）")
    private String resourceTypeName;

    @ApiModelProperty(value = "所在建筑id")
    private Long belongBuildingId;

    @ApiModelProperty(value = "所在建筑")
    private String belongBuilding;

    @ApiModelProperty(value = "所属消防系统id")
    private Long belongFightingSystemId;

    @ApiModelProperty(value = "所属消防系统")
    private String belongFightingSystem;

    @ApiModelProperty(value = "管理单位id")
    private Long managementUnitId;

    @ApiModelProperty(value = "管理单位")
    private String managementUnit;

    @ApiModelProperty(value = "维保单位id")
    private Long maintenanceUnitId;

    @ApiModelProperty(value = "维保单位")
    private String maintenanceUnit;

    @ApiModelProperty(value = "建造日期")
    private Date buildDate;

    @ApiModelProperty(value = "启用日期")
    private Date enableDate;

    @ApiModelProperty(value = "方位图集合")
    private List<Object> orientationImgList;

    @ApiModelProperty(value = "实景图集合")
    private List<Object> realityImgList;

    @ApiModelProperty(value = "方位图")
    private String orientationImg;

    @ApiModelProperty(value = "实景图")
    private String realityImg;

    @ApiModelProperty(value = "联系人姓名")
    private String contactUser;

    @ApiModelProperty(value = "联系人电话")
    private String contactPhone;

    @ApiModelProperty(value = "是否有物联参数（1有，0没有）")
    private Boolean isIot;

    @ApiModelProperty(value = "消防救援机构_通用唯一识别码")
    private String rescueOrgCode;

    @ApiModelProperty(value = "行政区划代码")
    private String administrativeCode;

    @ApiModelProperty(value = "更新人员")
    private String recUserName;

    @ApiModelProperty(value = "组织机构代码")
    private String orgCode;

    @ApiModelProperty(value = "资源id")
    private Long resourceId;

    @ApiModelProperty(value = "高度（cm）")
    private Float height;

    @ApiModelProperty(value = "水源可用状态类别代码")
    private String statusCode;

    @ApiModelProperty(value = "水源可用状态类别名称")
    private String status;

    @ApiModelProperty(value = "所属路段")
    private String section;

    @ApiModelProperty(value = "所属管网")
    private String pipeNetwork;

    @ApiModelProperty(value = "消防给水管网形式类型代码")
    private String pipeTypeCode;

    @ApiModelProperty(value = "消防给水管网形式")
    private String pipeTypeName;

    @ApiModelProperty(value = "管网直径（cm）")
    private Float pipeDiameter;

    @ApiModelProperty(value = "进水管直径(cm)")
    private Float inletPipeDiameter;

    @ApiModelProperty(value = "出水管直径(cm)")
    private Float outletPipeDiameter;

    @ApiModelProperty(value = "加水车道数量(个)")
    private Integer waterfillingLaneNum;

    @ApiModelProperty(value = "供水单位名称")
    private String waterSupplyName;

    @ApiModelProperty(value = "消火栓系统类型")
    private String systemType;

    @ApiModelProperty(value = "消火栓系统类型code")
    private String systemTypeCode;

    @ApiModelProperty(value = "消防设施状况分类")
    private String facilitiesCategory;

    @ApiModelProperty(value = "消防设施状况分类code")
    private String facilitiesCategoryCode;

    @ApiModelProperty(value = "道路路口路段简要情况")
    private String roadJunctionInfo;

    @ApiModelProperty(value = "消火栓放置形式")
    private String placeForm;

    @ApiModelProperty(value = "消火栓放置形式code")
    private String placeFormCode;

    @ApiModelProperty(value = "消防水带接口")
    private String hoseConnection;

    @ApiModelProperty(value = "消防水带接口code")
    private String hoseConnectionCode;

    @ApiModelProperty(value = "取水形式")
    private String intakeForm;

    @ApiModelProperty(value = "水源类型代码")
    private String typeCode;

    @ApiModelProperty(value = "水源类型")
    private String type;

    @ApiModelProperty(value = "容积（m³）")
    private Float volume;

    @ApiModelProperty(value = "面积（㎡）")
    private Float area;

    @ApiModelProperty(value = "水质情况")
    private String qualitySituationInfo;

    @ApiModelProperty(value = "四季变化简要情况")
    private String seasonChangeInfo;

    @ApiModelProperty(value = "有无枯水期")
    private Boolean hasDrySeason;

    @ApiModelProperty(value = "枯水期跨度简要情况")
    private String dryPeriodSpan;

    @ApiModelProperty(value = "取水高度(cm)")
    private Float intakeHeight;

    @ApiModelProperty(value = "水源标高差(cm)")
    private Float elevationDifference;

    @ApiModelProperty(value = "停车位置")
    private String parkingPosition;

    @ApiModelProperty(value = "停车数量(个)")
    private Integer parkingNum;

    @ApiModelProperty(value = "储水量容积物联编码")
    private String iotWaterStorage;

    @ApiModelProperty(value = "流量物联编码")
    private String iotFlowRate;

    @ApiModelProperty(value = "状态物联编码")
    private String iotStatus;

    @ApiModelProperty(value = "管网压力物联编码")
    private String iotPipePressure;

    @ApiModelProperty("设施定义Id")
    private Long equipId;

    @ApiModelProperty("设施编码")
    private String equipCode;

    @ApiModelProperty("设施定义名称")
    private String equipName;
}