package com.yeejoin.equipmanage.common.entity.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 区域
 *
 * @author duanwei
 * @date 2021-04-27
 */
@Data
@Accessors(chain = true)
@TableName("wl_area")
@ApiModel(value = "AreaVo", description = "区域")
public class AreaVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "区域名称")
    private String name;

    @ApiModelProperty(value = "区域编码")
    private String code;

    @ApiModelProperty(value = "区域类型")
    private String type;

    @ApiModelProperty(value = "父id")
    private Long parentId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "是否删除:0-否；1-是")
    private Boolean isDelete;

    @ApiModelProperty(value = "单位编码")
    private String orgCode;

    @ApiModelProperty(value = "创建人id")
    private Long creatorId;

}
