package com.yeejoin.equipmanage.common.request;

import com.yeejoin.equipmanage.common.vo.Request3dVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.common.response
 * @ClassName: Common3dResponse
 * @Author: Jianqiang Gao
 * @Description: Common3dResponse
 * @Date: 2021/6/3 11:03
 * @Version: 1.0
 */
@Data
@ApiModel(description = "数字化三维统一规范")
public class Common3dRequest {

    /**
     * id
     */
    private Integer id;
    /**
     * 操作状态
     */
    @ApiModelProperty(required = true, value = "操作状态")
    private String clientId;

    /**
     * 数据
     */
    @ApiModelProperty(required = false, value = "数据")
    private Request3dVo body;

}