package com.yeejoin.amos.maintenance.dao.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Where;

import cn.afterturn.easypoi.excel.annotation.Excel;


/**
 * The persistent class for the p_point database table.
 *
 */
@Entity
@Table(name="p_point")
@NamedQuery(name="Point.findAll", query="SELECT p FROM Point p")
@Where(clause="is_delete=0")//表示未删除的数据
public class Point extends BasicEntity {
	private static final long serialVersionUID = 1L;

	public String getBuildingId() {
		return buildingId;
	}

	public void setBuildingId(String buildingId) {
		this.buildingId = buildingId;
	}

	public String getBuildingName() {
		return buildingName;
	}

	public void setBuildingName(String buildingName) {
		this.buildingName = buildingName;
	}

	/**
	 * 参考地址
	 */
	@Excel(name = "参考地址", orderNum = "5")
	private String address;

	/**
	 * 分类编号
	 */
	@Column(name="catalog_id")
	private long catalogId;

	/**
	 * 3维坐标(x,y,z)
	 */
	private String coordinates;

	/**
	 * 创建用户id
	 */
	@Column(name="creator_id")
	private String creatorId;

	/**
	 * 有效巡检距离
	 */
//	@Excel(name = "有效巡检距离", orderNum = "7")
	private int distance;

	/**
	 * 扩展字段
	 */
//	@Excel(name = "扩展属性", orderNum = "16")
	@Lob
	@Column(name="extend_json")
	private String extendJson;

	/**
	 * 维保公司id
	 */
	private String companyId;

	/**
	 * 维保公司名称
	 */
	private String companyName;

	public String getCompanyId() {
		return companyId;
	}

	public void setCompanyId(String companyId) {
		this.companyId = companyId;
	}

	public String getCompanyName() {
		return companyName;
	}

	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	/**
	 * 定点拍照数
	 */
	@Column(name="fixed_shot")
	private int fixedShot;

	/**
	 * 是否为固定点(1:固定点，0：移动点)
	 */
	@Excel(name = "是否为移动点", replace={"是_0", "否_1"}, orderNum = "2")
	@Column(name="is_fixed")
	private String isFixed = "1";

	/**
	 * 无计划巡检是否评分(is_score = 1评分,0不评分)
	 */
	@Excel(name = "计划外巡检是否评分", replace={"是_0", "否_1"}, orderNum = "3")
	@Column(name="is_score")
	private String isScore = "0";

	/**
	 * 最新更新时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="last_update_time")
	private Date lastUpdateTime;

	public String getLastCheckId() {
		return lastCheckId;
	}

	public void setLastCheckId(String lastCheckId) {
		this.lastCheckId = lastCheckId;
	}

	/**
     * 最近检查记录（漏检不算）
     */
	private String lastCheckId;

	/**
	 * 经度
	 */
	private String latitude;

	/**
	 * 风险等级(1:一级，2：二级，3：三级，4：四级，5：五级)
	 */
	private String level;

	/**
	 * 纬度
	 */
	private String longitude;

	/**
	 * 点名称
	 */
	@Excel(name = "点名称", orderNum = "0")
	private String name;

	/**
	 * 是否允许离线巡检
	 */
	@Excel(name = "是否允许离线巡检", replace={"是_1", "否_0"}, orderNum = "4")
	private Boolean offline = false;

	/**
	 * 权限系统org code
	 */
	@Column(name="org_code")
	private String orgCode;

	/**
	 * 点编号
	 */
	@Excel(name = "点编号", orderNum = "1")
	@Column(name="point_no")
	private String pointNo;

	/**
	 * 所在建筑
	 */
	private String buildingId;


	/**
	 * 所在建筑名称
	 */
	private String buildingName;


    public String getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(String equipmentId) {
        this.equipmentId = equipmentId;
    }

    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    public String getBelongSystemId() {
        return belongSystemId;
    }

    public void setBelongSystemId(String belongSystemId) {
        this.belongSystemId = belongSystemId;
    }

    public String getBelongSystemName() {
        return belongSystemName;
    }

    public void setBelongSystemName(String belongSystemName) {
        this.belongSystemName = belongSystemName;
    }

    /**
	 * 备注说明
	 */
	@Excel(name = "备注说明", orderNum = "11")
	private String remark;

	/**
	 * 路线id
	 */
	@Column(name="route_id")
	private String routeId;

	/**
	 * 路线名称
	 */
	@Column(name="route_name")
	private String routeName;

	/**
	 * 是否保存地理信(1:记录，0：不记录)
	 */
	@Column(name="save_gps")
	private String saveGps = "0";

	/**
	 * 最大拍照数
	 */
	@Excel(name = "最多拍照数量", orderNum = "9")
	@Column(name="shot_max_number")
	private int shotMaxNumber;

	/**
	 * 最小拍照数
	 */
	@Excel(name = "最少拍照数量", orderNum = "8")
	@Column(name="shot_min_number")
	private int shotMinNumber;

	/**
	 * 是否允许普通拍照(1：允许，0：不允许)
	 */
	@Column(name="usually_shot")
	private String usuallyShot = "1";

	/**
	 * 是否删除：0表示未删除，1表示已删除
	 */
	@Column(name="is_delete")
	private boolean isDelete;

	/**
	 * 归属区域/部门id
	 */
	@Column(name="charge_dept_id")
	private String chargeDeptId ;

	/**
	 * 负责人id
	 */
	@Column(name="charge_person_id")
	private String chargePersonId ;

	/**
	 * 状态：0 未纳入巡检，1 合格；2 不合格；3 漏检
	 */
	@Column(name="status")
	private String status="0";

	/**
	 * 3维模型楼层
	 */
	private Integer floor = 1;

	/**
	 * 是否室内
	 */
	@Excel(name = "是否室内", replace={"是_1", "否_0"}, orderNum = "14")
	@Column(name="is_indoor")
	private Boolean isIndoor=false;

	/**
	 * 原始字段
	 */
	@Column(name = "original_id", columnDefinition = "varchar(50) COMMENT '原始字段'")
	private String originalId;

	/**
	 * 风险源id
	 */
	@Column(name="risk_source_id")
	private String riskSourceId;

	/**
	 * ue4位置
	 */

	private String ue4Location;

	/**
	 * ue4旋转
	 */

	private String ue4Rotation;

	/**
	 * 物理区域id（数据来源于装备wl_area）
	 */
	private Long areaId;
	/**
	 * 物理区域名称（数据来源于装备wl_area）
	 */
	private String areaName;

	/**
	 * 装备定义id
	 */
	private String equipmentId;

	/**
	 * 装备定义名称（冗余字段）
	 */
	private String equipmentName;

	/**
	 * 所属消防系统id
	 */
	private String belongSystemId;
	/**
	 * 所属消防系统名称（冗余字段)
	 */
	private String belongSystemName;

	/**
	 * 业主单位
	 */
	@Column(name="owner_id")
	private String ownerId;
	/**
	 * 业主单位名称
	 */
	@Column(name="owner_name")
	private String ownerName;

	public String getOwnerId() {
		return ownerId;
	}

	public void setOwnerId(String ownerId) {
		this.ownerId = ownerId;
	}

	public String getOwnerName() {
		return ownerName;
	}

	public void setOwnerName(String ownerName) {
		this.ownerName = ownerName;
	}

	public Long getAreaId() {
		return areaId;
	}

	public void setAreaId(Long areaId) {
		this.areaId = areaId;
	}

	public String getAreaName() {
		return areaName;
	}

	public void setAreaName(String areaName) {
		this.areaName = areaName;
	}

	public String getRiskSourceId() {
		return riskSourceId;
	}

	public void setRiskSourceId(String riskSourceId) {
		this.riskSourceId = riskSourceId;
	}

	public Boolean getIsIndoor() {
		return isIndoor;
	}

	public void setIsIndoor(Boolean isIndoor) {
		this.isIndoor = isIndoor;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Point() {
	}

	public String getAddress() {
		return this.address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public long getCatalogId() {
		return this.catalogId;
	}

	public void setCatalogId(long catalogId) {
		this.catalogId = catalogId;
	}

	public String getCoordinates() {
		return this.coordinates;
	}

	public void setCoordinates(String coordinates) {
		this.coordinates = coordinates;
	}

	public String getCreatorId() {
		return this.creatorId;
	}

	public void setCreatorId(String creatorId) {
		this.creatorId = creatorId;
	}

	public int getDistance() {
		return this.distance;
	}

	public void setDistance(int distance) {
		this.distance = distance;
	}

	public String getExtendJson() {
		return this.extendJson;
	}

	public void setExtendJson(String extendJson) {
		this.extendJson = extendJson;
	}

	public int getFixedShot() {
		return this.fixedShot;
	}

	public void setFixedShot(int fixedShot) {
		this.fixedShot = fixedShot;
	}

	public String getIsFixed() {
		return this.isFixed;
	}

	public void setIsFixed(String isFixed) {
		this.isFixed = isFixed;
	}

	public String getIsScore() {
		return this.isScore;
	}

	public void setIsScore(String isScore) {
		this.isScore = isScore;
	}

	public Date getLastUpdateTime() {
		return this.lastUpdateTime;
	}

	public void setLastUpdateTime(Date lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	public String getLatitude() {
		return this.latitude;
	}

	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	public String getLevel() {
		return this.level;
	}

	public void setLevel(String level) {
		this.level = level;
	}

	public String getLongitude() {
		return this.longitude;
	}

	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Boolean getOffline() {
		return this.offline;
	}

	public void setOffline(Boolean offline) {
		this.offline = offline;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getPointNo() {
		return this.pointNo;
	}

	public void setPointNo(String pointNo) {
		this.pointNo = pointNo;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getRouteId() {
		return this.routeId;
	}

	public void setRouteId(String routeId) {
		this.routeId = routeId;
	}

	public String getRouteName() {
		return this.routeName;
	}

	public void setRouteName(String routeName) {
		this.routeName = routeName;
	}

	public String getSaveGps() {
		return this.saveGps;
	}

	public void setSaveGps(String saveGps) {
		this.saveGps = saveGps;
	}

	public int getShotMaxNumber() {
		return this.shotMaxNumber;
	}

	public void setShotMaxNumber(int shotMaxNumber) {
		this.shotMaxNumber = shotMaxNumber;
	}

	public int getShotMinNumber() {
		return this.shotMinNumber;
	}

	public void setShotMinNumber(int shotMinNumber) {
		this.shotMinNumber = shotMinNumber;
	}

	public String getUsuallyShot() {
		return this.usuallyShot;
	}

	public void setUsuallyShot(String usuallyShot) {
		this.usuallyShot = usuallyShot;
	}

	public boolean getIsDelete() {
		return isDelete;
	}

	public void setIsDelete(boolean isDelete) {
		this.isDelete = isDelete;
	}

	public String getChargeDeptId() {
		return chargeDeptId;
	}

	public void setChargeDeptId(String chargeDeptId) {
		this.chargeDeptId = chargeDeptId;
	}

	public String getChargePersonId() {
		return chargePersonId;
	}

	public void setChargePersonId(String chargePersonId) {
		this.chargePersonId = chargePersonId;
	}

	public Integer getFloor() {
		return floor;
	}

	public void setFloor(Integer floor) {
		this.floor = floor;
	}

	public String getOriginalId() {
		return originalId;
	}

	public void setOriginalId(String originalId) {
		this.originalId = originalId;
	}
	@Lob
	@Column(name = "ue4_rotation")
	public String getUe4Location() {
		return ue4Location;
	}

	public void setUe4Location(String ue4Location) {
		this.ue4Location = ue4Location;
	}
	@Lob
	@Column(name = "ue4_location")
	public String getUe4Rotation() {
		return ue4Rotation;
	}

	public void setUe4Rotation(String ue4Rotation) {
		this.ue4Rotation = ue4Rotation;
	}
}