package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.remote.RemoteSecurityService;
import com.yeejoin.equipmanage.service.IVisitorRecordingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * <h1><h1>
 *
 * @author tiantao
 * @date 2021/3/1 11:24
 */
@RestController
@Api(tags = "访客记录Api")
@RequestMapping(value = "/visitor-recording", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class VisitorRecordingController extends AbstractBaseController{

    @Autowired
    private IVisitorRecordingService visitorRecordingService;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    /**
     * 记录列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", produces = "application/json;charset=UTF-8", notes = "列表分页查询")
    public ResponseModel listPage(@RequestParam(value = "visitorName", required = false) String visitorName,
                                  @RequestParam(value = "phoneNumber", required = false) String phoneNumber,
                                  @RequestParam(value = "hostName", required = false) String hostName,
                                  @RequestParam(value = "visitorCompany", required = false) String visitorCompany,
                                  @RequestParam(value = "targetDepartmentId", required = false) Long targetDepartmentId,
                                  @RequestParam(value = "size", required = false, defaultValue = "10") Integer size,
                                  @RequestParam(value = "current", required = false, defaultValue = "1") Integer current) {
        Page page= new Page(current, size);
        return CommonResponseUtil.success(visitorRecordingService.listByParams(visitorName, phoneNumber, hostName, visitorCompany, targetDepartmentId, page));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "删除访客记录", produces = "application/json;charset=UTF-8", notes = "删除访客记录")
    @DeleteMapping(value = "/delete")
    public ResponseModel deleteById(@RequestParam String ids) {
        return CommonResponseUtil.success(visitorRecordingService.deleteByIds(ids));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出访客记录", produces = "application/json;charset=UTF-8", notes = "导出访客记录")
    @GetMapping(value = "/export")
    public void exportByParams(HttpServletResponse response,
                                        @RequestParam(value = "ids", required = false) List<Long> ids,
                                        @RequestParam(value = "visitorName", required = false) String visitorName,
                                        @RequestParam(value = "phoneNumber", required = false) String phoneNumber,
                                        @RequestParam(value = "hostName", required = false) String hostName,
                                        @RequestParam(value = "visitorCompany", required = false) String visitorCompany,
                                        @RequestParam(value = "targetDepartmentId", required = false) Long targetDepartmentId) {
        visitorRecordingService.exportByParams(response, ids, visitorName, phoneNumber, hostName, visitorCompany,
                targetDepartmentId);
    }
}
