package com.yeejoin.equipmanage.operation;

import com.yeejoin.equipmanage.common.entity.dto.BuildSearchDTO;
import com.yeejoin.equipmanage.common.enums.GroupTypeEnum;
import com.yeejoin.equipmanage.context.SpringContextHolder;
import com.yeejoin.equipmanage.service.IFormInstanceService;
import com.yeejoin.equipmanage.service.impl.FormInstanceServiceImpl;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Author: songLei
 * @Description: 不同算法分支的实现
 * @Date: 2020/12/23 19:06
 * @Version: 1.0
 */
@Getter
@AllArgsConstructor
public enum GroupTypeOperator {
    ALLBUILDING("allBuilding"){
        @Override
        public void apply(Map<String,Object> map) {

        }
    },
    BUILDING("building"){
        @Override
        public void apply(Map<String,Object> map) {
            map.put("sourceFloor","无");
        }
    },
    ROOM("room"){
        @Override
        public void apply(Map<String,Object> map) {
            IFormInstanceService formInstanceService = SpringContextHolder.getBean(FormInstanceServiceImpl.class);
            BuildSearchDTO dto = new BuildSearchDTO();
            List<Long> ids = new ArrayList<>();
            ids.add(Long.parseLong(String.valueOf(map.get("parentId"))));
            dto.setInstanceIds(ids);
            List<Map<String,Object>> inMap = formInstanceService.roomPage(dto);
            Map<String,Object> pMap = inMap.parallelStream().findFirst().orElse(null);
            if(pMap.get("groupType").equals(GroupTypeEnum.FLOOR.getType())){
                map.put("sourceFloor",String.valueOf(pMap.get("buildName")));
            }else {
                map.put("sourceFloor","无");
            }
        }
    },
    FLOOR("floor"){
        @Override
        public void apply(Map<String,Object> map) {
            IFormInstanceService formInstanceService = SpringContextHolder.getBean(FormInstanceServiceImpl.class);
            BuildSearchDTO dto = new BuildSearchDTO();
            List<Long> ids = new ArrayList<>();
            ids.add(Long.parseLong(String.valueOf(map.get("parentId"))));
            dto.setInstanceIds(ids);
            List<Map<String,Object>> inMap = formInstanceService.roomPage(dto);
            if (CollectionUtils.isNotEmpty(inMap)) {
                Map<String,Object> pMap = inMap.parallelStream().findFirst().orElse(null);
                if(pMap.get("groupType").equals(GroupTypeEnum.BUILDING.getType())){
                    map.put("sourceBuild",String.valueOf(pMap.get("buildName")));
                }else {
                    map.put("sourceBuild","无");
                }
            } else {
                map.put("sourceBuild","无");
            }
        }
    };
    public abstract void apply(Map<String,Object> map);
    private String type;
}
