package com.yeejoin.equipmanage.remote;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.equipmanage.common.entity.publics.CommonResponse;

import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;

/**
 * @author DELL
 */
@FeignClient(name= "${riskSource.feign.name}",configuration={MultipartSupportConfig.class,RiskModelFeign.Configuration.class})
public interface RiskModelFeign {
    /**
     * 查询公司对应的风险（厂区、区域、风险点）
     * @param orgCode 公司编码
     * @return List
     */
    @GetMapping("fireAutoSys/api/common/riskSource/list/{orgCode}")
    CommonResponse getRiskSourceList(@PathVariable(value="orgCode") String orgCode);
    
    /**
     *二级区域风险等级，风险值
     * @param orgCode 公司编码
     */
    @GetMapping("fireAutoSys/api/view3d/secondLevelRiskSource")
    CommonResponse querySecondLevelRiskSource();
    
    /**
     * 今日安全指数
     * @param date
     * @return
     */
	@GetMapping(value = "fireAutoSys/api/view3d/statistics/safetyIndex")
	CommonResponse getSafetyIndexInfoByDate(@RequestParam("date") String date);
	/**
	 * @Description 添加同步风险区域
	 * @param list
	 * @Return
	 * @Exception
	 * @Date 2020/12/29 19:36
	 */
	@PostMapping("fireAutoSys/api/risksource/syn/region")
    CommonResponse addSyncRisk(@RequestBody RiskSource riskSource);
    class Configuration {
        @Bean
        Encoder feignFormEncoder(ObjectFactory<HttpMessageConverters> converters) {
            return new SpringFormEncoder(new SpringEncoder(converters));
        }
    }
    /**
     * @Description 编辑同步风险区域
     * @param instanceId
     * @Return
     * @Exception
     * @Date 2020/12/29 19:36
     */
    @PutMapping("fireAutoSys/api/risksource/remove/bind")
    CommonResponse editSyncRisk(@RequestParam("instanceId") Long instanceId);

    /**
     * @Description 物理区域修改同步风险区域
     * @param
     * @Return
     * @Exception
     * @Date 2020/12/29 19:36
     */
    @PostMapping("fireAutoSys/api/risksource/syn/updateAreaSyn")
    CommonResponse updateAreaSyn(@RequestBody RiskSource riskSource);
}
