package com.yeejoin.amos.boot.module.jcs.biz.audioToText.entity;

import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Data
@Component
@ConfigurationProperties(prefix = "speech-config")
public class SpeechConfig implements InitializingBean {
    public String accessKeyId;
    public String accessKeySecret;
    public String appKey;

    @Override
    public void afterPropertiesSet() throws Exception {
        com.yeejoin.amos.speech.SpeechConfig.AccessKeyId = accessKeyId;
        com.yeejoin.amos.speech.SpeechConfig.AccessKeySecret = accessKeySecret;
        com.yeejoin.amos.speech.SpeechConfig.AppKey = appKey;
    }
}
