package com.yeejoin.amos.knowledgebase.face.orm.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.knowledgebase.face.orm.entity.KnowledgeTagValue;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.List;

/**
 * <p>
  * 值标签的实例值 Mapper 接口
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
public interface TagValueMapper extends BaseMapper<KnowledgeTagValue> {

    /**
     * 根据文档id查询标签值列表
     * @param docSeq 文档id
     * @return
     */
    List<KnowledgeTagValue> queryTagValuesByDocId(Long docSeq);

    /**
     * 根据文档id查询标签值列表
     * @param docIds 文档id列表
     * @return
     */
    List<KnowledgeTagValue> queryTagValuesByDocIds(@Param("docIds") Collection<Long> docIds);

}