package com.yeejoin.amos.maintenance.business.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.maintenance.business.service.intfc.ICheckService;
import com.yeejoin.amos.maintenance.business.service.intfc.IPlanTaskService;
import com.yeejoin.amos.maintenance.business.service.intfc.IPointService;
import com.yeejoin.amos.maintenance.business.service.intfc.ITaskService;
import com.yeejoin.amos.maintenance.business.util.CommonResponse;
import com.yeejoin.amos.maintenance.business.util.CommonResponseUtil;
import com.yeejoin.amos.maintenance.feign.RemoteSecurityService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = "/api/home")
@Api(tags="首页api")
public class HomeController extends AbstractBaseController{
	
	@Autowired
	private ICheckService checkService ;
	
	@Autowired
	private IPointService iPointService;
	
	@Autowired
	private ITaskService taskService;
	
	@Autowired
	private IPlanTaskService planTaskService ;
	/*@Autowired
	private IUserService userService;*/
	 @Autowired
	    private RemoteSecurityService remoteSecurityService;
	 
	 @TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "首页数据", notes = "首页数据")
	@GetMapping(value="/overviewData")
//	@Authorization(ingore = true)
	public CommonResponse init() {
		HashMap<String, Object> response = new HashMap<String, Object>();
		HashMap<String, Object> statusList = new HashMap<String, Object>();
		    ReginParams reginParams = getSelectedOrgInfo();
	        String loginOrgCode = getOrgCode(reginParams);
	        String companyName = getCompanyName(reginParams);
		/*if (XJConstant.ROLE_NAME_ADMIN.equals(loginParam.getRoleTypeName()) ||
				XJConstant.ROLE_NAME_SUPERADMIN.equals(loginParam.getRoleTypeName())) {
			orgCode = loginParam.getOrgCode();
		} else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(loginParam.getRoleTypeName())) {
			orgCode = loginParam.getUserOrgCode();
		}*/
		
		long point = iPointService.getPointCountByOrgCode(loginOrgCode);
		String task = taskService.getTaskFinishCountByOrgCode(loginOrgCode);
		long check = checkService.getCumulativeCheckCountByOrgCode(loginOrgCode);
		String plan = planTaskService.getCumulativePlanCountByOrgCode(loginOrgCode);
		 if(task==null){
	        	task="0/0";
	        }
	        if(plan==null){
	        	task="0/0";
	        }
		statusList.put("point", point);
		statusList.put("task", task);
		statusList.put("check", check);
		statusList.put("plan", plan);
		response.put("company", companyName);
		response.put("statusList", statusList);
		return CommonResponseUtil.success(response);
	}
	
	
	 @TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "首页数据", notes = "首页数据")
	@GetMapping(value="/getCheckData")
	public CommonResponse getCheckData() {
		   String userId = getUserId();
	        ReginParams reginParams = getSelectedOrgInfo();
	        String loginOrgCode = getOrgCode(reginParams);
	        String roleTypeName = getRoleTypeName(reginParams);
		SimpleDateFormat sdf = new SimpleDateFormat("MM月dd日");
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
		List<String> xAxis = new ArrayList<>();
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(new Date());
		calendar.add(Calendar.DAY_OF_YEAR, -11);
		String startTime = sdf1.format(calendar.getTime());
		for (int i = 0; i < 12; i++) {
			xAxis.add(sdf.format(calendar.getTime()));
			calendar.add(Calendar.DATE, 1);
		}
		String endTime = sdf1.format(calendar.getTime());
		HashMap<String, Object> param = new HashMap<String, Object>();
		/*if (XJConstant.ROLE_NAME_ADMIN.equals(loginParam.getRoleTypeName()) ||
				XJConstant.ROLE_NAME_SUPERADMIN.equals(loginParam.getRoleTypeName())) {
			param.put("orgCode", loginParam.getOrgCode());
		} else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(loginParam.getRoleTypeName())) {
			param.put("orgCode", loginParam.getUserOrgCode());
		} else {
			param.put("userId", getUserId());
		}*/
		//param.put("userId", getUserId());
		 param.put("orgCode", loginOrgCode);
		param.put("endTime", endTime);
		param.put("startTime", startTime);
		param.put("param", '3');
		param.put("type", 1);
		List<Long> check = checkService.getCheckDataCount(param);
		param.put("type", 2);
		param.put("param", 0);
		List<Long> plan = checkService.getPlanCheckDataCount(param);
		param.put("type", 3);
		param.put("param", '3');
		List<Long> missed = checkService.getCheckDataCount(param);
		HashMap<String, Object> response = new HashMap<String, Object>();
		response.put("check", check);
		response.put("plan", plan);
		response.put("missed", missed);
		response.put("xAxis", xAxis);
		return CommonResponseUtil.success(response);
	}
}