package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotEmpty;
import java.util.Date;
import java.util.List;

/**
 * 发货单
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="PreparationMoneyDto", description="发货单")
@JsonIgnoreProperties(ignoreUnknown = true)
public class PreparationMoneyDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = " 单号")
    private String oddNumbers;

    @ApiModelProperty(value = " 收货地址")
    private String deliveryAddress;

    @ApiModelProperty(value = "详细地址")
    private String detailAddress;

    @ApiModelProperty(value = " 下单人")
    private String orderUser;

    @ApiModelProperty(value = "下单时间")
    @JsonFormat (pattern="yyyy-MM-dd")
    private Date orderTime;

    @ApiModelProperty(value = "经销商id")
    private String dealerId;

    @ApiModelProperty(value = "经销商名称")
    private String dealerName;

    @ApiModelProperty(value = " 发货地址")
    @TableField (typeHandler = FastjsonTypeHandler.class)
    private List<String> sendAddress;

    @ApiModelProperty(value = " 业主类型")
    private String ownerType;

    @ApiModelProperty(value = "业务员")
    private String salesman;

    @ApiModelProperty(value = "预估重量")
    private Double estimatedWeight;

    @ApiModelProperty(value = "备注")
    private String notes;

    @ApiModelProperty(value = "收货人")
    private String consignee;

    @ApiModelProperty(value = "收货人手机号")
    private String consigneePhone;

    @ApiModelProperty(value = "收货人地址")
    @TableField (typeHandler = FastjsonTypeHandler.class)
    private List<String> consigneeAddress;

    @ApiModelProperty(value = "收货人详细地址")
    private String consigneeDetailAddress;

    @ApiModelProperty(value = "发货单")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> invoice;

    @ApiModelProperty(value = "收货单")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> receipt;

    @ApiModelProperty(value = "订单状态0未完成1已完成2作废")
    private String documentState;

    @ApiModelProperty(value = "发货状态 0 未发货1已发货")
    private String shipmentStatus;

    @ApiModelProperty(value = "到货状态0未到货1已到货")
    private String receivingStatus;

    @ApiModelProperty(value = "清单价格")
    private Double inventoryPrice;

    @ApiModelProperty(value = "折扣")
    private Double discount;

    @ApiModelProperty(value = "促销")
    private Double promotion;

    @ApiModelProperty(value = "合同价格")
    private Double contractPrice;

    @ApiModelProperty(value = "总价")
    private Double totalPrice;

    @ApiModelProperty(value = "到货时间")
    @JsonFormat (pattern="yyyy-MM-dd")
    private Date deliveryTime;

    @ApiModelProperty(value = "发货电站列表")
    @NotEmpty(message = "请选择发货电站")
    private List<PeasantHouseholdDto> powerStations;

    @ApiModelProperty(value = "BOM清单")
    private List<DocumentBomDto> documentBoms;

    @ApiModelProperty(value = "单据追踪")
    private List<PreparationMoneyLogDto> preparationMoneyLogs;
}
