package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.hygf.api.dto.CommonFile;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 经销商单位信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_commerce_info")
public class CommerceInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 统一信用代码
     */
	@TableField("credit_code")
    private String creditCode;

    /**
     * 营业执照
     */
	@TableField("business_license_photo")
    private String businessLicensePhoto;

    /**
     * 法人名字
     */
	@TableField("legal_person_name")
    private String legalPersonName;

    /**
     * 法人身份证号
     */
	@TableField("legal_person_id_number")
    private String legalPersonIdNumber;

    /**
     * 法人身份证照片正面
     */
	@TableField("legal_person_card_photo_front")
    private String legalPersonCardPhotoFront;

    /**
     * 法人身份证照片反面
     */
	@TableField("legal_person_card_photo_back")
    private String legalPersonCardPhotoBack;

    /**
     * 法人联系方式
     */
	@TableField("legal_person_phone")
    private String legalPersonPhone;

    /**
     * 单位id
     */
	@TableField("unit_seq")
    private Long unitSeq;

    @TableField(exist=false)
    private List<CommonFile> legalPersonCardPhotoFrontList;
    @TableField(exist=false)
    private List<CommonFile> legalPersonCardPhotoBackList;

    @TableField(exist=false)
    private List<CommonFile> businessLicensePhotoList;
}
