package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 设计信息
 *
 * @author system_generator
 * @date 2023-07-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_design_information",autoResultMap = true)
public class DesignInformation extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 典型设计图信息
     */
	@TableField(value = "typical_diagram",typeHandler = FastjsonTypeHandler.class,updateStrategy = FieldStrategy.IGNORED)
    private List<Object> typicalDiagram;

    /**
     * 组件排布图
     */
	@TableField(value = "component_layout",typeHandler = FastjsonTypeHandler.class,updateStrategy = FieldStrategy.IGNORED)
    private List<Object> componentLayout;

    /**
     * 组件支架图
     */
	@TableField(value = "component_bracket",typeHandler = FastjsonTypeHandler.class,updateStrategy = FieldStrategy.IGNORED)
    private List<Object> componentBracket;

    /**
     * 组串接线图
     */
	@TableField(value = "connection_line",typeHandler = FastjsonTypeHandler.class,updateStrategy = FieldStrategy.IGNORED)
    private List<Object> connectionLine;

    /**
     * 一次接线图
     */
	@TableField(value = "once_line",typeHandler = FastjsonTypeHandler.class,updateStrategy = FieldStrategy.IGNORED)
    private List<Object> onceLine;

    /**
     * 组件
     */
	@TableField(value = "assembly",typeHandler = FastjsonTypeHandler.class,updateStrategy = FieldStrategy.IGNORED)
    private List<Object> assembly;

    /**
     * 逆变器
     */
	@TableField(value = "inverter",typeHandler = FastjsonTypeHandler.class,updateStrategy = FieldStrategy.IGNORED)
    private List<Object> inverter;

    /**
     * 电表箱
     */
	@TableField(value = "electricity_meter",typeHandler = FastjsonTypeHandler.class,updateStrategy = FieldStrategy.IGNORED)
    private List<Object> electricityMeter;

    /**
     * 支架
     */
	@TableField(value = "support",typeHandler = FastjsonTypeHandler.class,updateStrategy = FieldStrategy.IGNORED)
    private List<Object> support;

    /**
     *  防滑雪措施
     */
	@TableField(value = "anti_skiing",updateStrategy = FieldStrategy.IGNORED)
    private String antiSkiing;

    /**
     *  防滑雪措施备注
     */
	@TableField(value = "anti_skiing_notes",updateStrategy = FieldStrategy.IGNORED)
    private String antiSkiingNotes;

    /**
     *  抽检
     */
	@TableField(value = "spot_check",updateStrategy = FieldStrategy.IGNORED)
    private String spotCheck;

    /**
     *  抽检意见
     */
	@TableField(value = "spot_check_opinion",updateStrategy = FieldStrategy.IGNORED)
    private String spotCheckOpinion;

    /**
     * 是否定制
     */
	@TableField(value = "isok_customized",updateStrategy = FieldStrategy.IGNORED)
    private String isokCustomized;

    /**
     * 是否加固
     */
	@TableField(value = "wind_resistant",updateStrategy = FieldStrategy.IGNORED)
    private String windResistant;

    /**
     * 试点方案
     */
	@TableField(value = "pilot_program",updateStrategy = FieldStrategy.IGNORED)
    private String pilotProgram;

    /**
     *  s试点物料
     */
	@TableField(value = "pilot_materials",updateStrategy = FieldStrategy.IGNORED)
    private String pilotMaterials;

    /**
     * 方位角
     */
	@TableField(value = "azimuth",updateStrategy = FieldStrategy.IGNORED)
    private String azimuth;

    /**
     * 倾角
     */
	@TableField(value = "dip_angle",updateStrategy = FieldStrategy.IGNORED)
    private String dipAngle;

    /**
     *  应用场景
     */
	@TableField(value = "application_scenario",updateStrategy = FieldStrategy.IGNORED)
    private String applicationScenario;

    /**
     * 应用场景数量
     */
	@TableField(value = "application_scenario_num",updateStrategy = FieldStrategy.IGNORED)
    private Integer applicationScenarioNum;

    /**
     * 支架方案
     */
	@TableField(value = "support_scheme",updateStrategy = FieldStrategy.IGNORED)
    private String supportScheme;

    /**
     * 支架方案数量
     */
	@TableField(value = "support_scheme_num",updateStrategy = FieldStrategy.IGNORED)
    private Integer supportSchemeNum;

    /**
     * 特殊方案
     */
	@TableField(value = "special_plan",updateStrategy = FieldStrategy.IGNORED)
    private String specialPlan;

    /**
     * 特殊方案数量
     */
	@TableField(value = "special_plan_num",updateStrategy = FieldStrategy.IGNORED)
    private Integer specialPlanNum;

    /**
     * 农户id
     */
    @TableField(value = "peasant_household_id",updateStrategy = FieldStrategy.IGNORED)
    private String peasantHouseholdId;

}
