package com.yeejoin.amos.boot.module.hygf.api.util;

import org.springframework.http.HttpStatus;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import com.yeejoin.amos.boot.module.hygf.api.util.Constants;
public class CommonResponseNewUtil
{
	public static ResponseModel success()
	{	
		ResponseModel res = new ResponseModel();
        res.setDevMessage(Constants.RESULT_SUCCESS);
        res.setStatus(HttpStatus.OK.value());
		return res;
	}

	public static ResponseModel success(Object obj)
	{	
		ResponseModel res = new ResponseModel();
        res.setResult(obj);
        res.setDevMessage(Constants.RESULT_SUCCESS);
        res.setStatus(HttpStatus.OK.value());
		return res;
	}

	public static ResponseModel success(Object obj, String message)
	{	
		ResponseModel res = new ResponseModel();
        res.setResult(obj);
        res.setDevMessage(message);
        res.setStatus(HttpStatus.OK.value());
		return res;
	}

	public static ResponseModel failure()
	{	
		ResponseModel res = new ResponseModel();
        res.setDevMessage(Constants.RESULT_FAILURE);
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
		return res;
	}

	public static ResponseModel failure(String message)
	{
		ResponseModel res = new ResponseModel();
        res.setDevMessage(Constants.RESULT_FAILURE);
        res.setMessage(message);
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
		return res;
	}

	public static ResponseModel failure(Object obj, String message)
	{
		ResponseModel res = new ResponseModel();
        res.setResult(obj);
        res.setDevMessage(Constants.RESULT_FAILURE);
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
		return res;
	}
}
