package com.yeejoin.amos.boot.module.hygf.api.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtil {

	public static long getStartTimeOfDay(Date day) {
		Calendar todayStart = Calendar.getInstance();
		todayStart.setTime(day);
		todayStart.set(Calendar.HOUR_OF_DAY, 0);
		todayStart.set(Calendar.MINUTE, 0);
		todayStart.set(Calendar.SECOND, 0);
		todayStart.set(Calendar.MILLISECOND, 0);
		return todayStart.getTime().getTime();
	}

	public static long getEndTimeOfDay(Date day) {
		Calendar todayEnd = Calendar.getInstance();
		todayEnd.set(Calendar.HOUR_OF_DAY, 23);
		todayEnd.set(Calendar.MINUTE, 59);
		todayEnd.set(Calendar.SECOND, 59);
		todayEnd.set(Calendar.MILLISECOND, 999);
		return todayEnd.getTime().getTime();
	}

	public static String dateFormat(Long time) {
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return dateFormat.format(new Date(time));
	}
	
	public static String minuteFormat(Long time) {
		SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
		return dateFormat.format(new Date(time));
	}

	public static String longFormat(Long time) {
		if (time < 1000) {
			return "0" + "秒";
		}
		long second = time / 1000;
		long seconds = second % 60;
		long minutes = second / 60;
		long hours = 0;
		if (minutes >= 60) {
			hours = minutes / 60;
			minutes = minutes % 60;
		}
		String timeString = "";
		String secondString = "";
		String minuteString = "";
		String hourString = "";
		if (seconds < 10) {
			secondString = "0" + seconds + "秒";
		} else {
			secondString = seconds + "秒";
		}
		if (minutes < 10 && hours < 1) {
			minuteString = minutes + "分";
		} else if (minutes < 10) {
			minuteString = "0" + minutes + "分";
		} else {
			minuteString = minutes + "分";
		}
		if (hours < 10) {
			hourString = hours + "时";
		} else {
			hourString = hours + "" + "时";
		}
		if (hours != 0) {
			timeString = hourString + minuteString + secondString;
		} else {
			timeString = minuteString + secondString;
		}
		return timeString;
	}
}
