package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpStationDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpPersonStation;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpStation;
import com.yeejoin.amos.boot.module.hygf.api.entity.TdHygfJpInverterWarn;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpPersonStationMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpStationMapper;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.TdHygfJpInverterWarnMapper;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.TdHygfJpInverterWarnServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.TdHygfJpInverterWarnDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 户用光伏监盘逆变器报警表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@RestController
@Api(tags = "户用光伏监盘逆变器报警表Api")
@RequestMapping(value = "/td-hygf-jp-inverter-warn")
public class TdHygfJpInverterWarnController extends BaseController {

	@Autowired
	TdHygfJpInverterWarnServiceImpl tdHygfJpInverterWarnServiceImpl;
	@Autowired
	JpPersonStationMapper pPersonStationMapper;
	@Autowired
	TdHygfJpInverterWarnMapper tdHygfJpInverterWarnMapper;
	@Autowired
	JpStationMapper jpStationMapper;

	/**
	 * 新增户用光伏监盘逆变器报警表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增户用光伏监盘逆变器报警表", notes = "新增户用光伏监盘逆变器报警表")
	public ResponseModel<TdHygfJpInverterWarnDto> save(@RequestBody TdHygfJpInverterWarnDto model) {
		model = tdHygfJpInverterWarnServiceImpl.createWithModel(model);
		return ResponseHelper.buildResponse(model);
	}

	/**
	 * 根据sequenceNbr更新
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏监盘逆变器报警表", notes = "根据sequenceNbr更新户用光伏监盘逆变器报警表")

	public ResponseModel<TdHygfJpInverterWarnDto> updateBySequenceNbrTdHygfJpInverterWarn(
			@RequestBody TdHygfJpInverterWarnDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(tdHygfJpInverterWarnServiceImpl.updateWithModel(model));

	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏监盘逆变器报警表", notes = "根据sequenceNbr删除户用光伏监盘逆变器报警表")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,
			@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(tdHygfJpInverterWarnServiceImpl.removeById(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个户用光伏监盘逆变器报警表", notes = "根据sequenceNbr查询单个户用光伏监盘逆变器报警表")
	public ResponseModel<TdHygfJpInverterWarnDto> selectOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(tdHygfJpInverterWarnServiceImpl.queryBySeq(sequenceNbr));
	}
	
	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "time/{createdTime}")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个户用光伏监盘逆变器报警表", notes = "根据sequenceNbr查询单个户用光伏监盘逆变器报警表")
	public ResponseModel<TdHygfJpInverterWarnDto> selectCreatedTime(@PathVariable Long createdTime) {
		return ResponseHelper.buildResponse(tdHygfJpInverterWarnServiceImpl.queryByCreatedTime(createdTime));
	}

	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘逆变器报警表分页查询", notes = "户用光伏监盘逆变器报警表分页查询")
	public ResponseModel<Page<TdHygfJpInverterWarnDto>> queryForPage(@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size, TdHygfJpInverterWarnDto tdHygfJpInverterWarnDto) {
		LambdaQueryWrapper<JpPersonStation> qug = new LambdaQueryWrapper<>();
		qug.eq(JpPersonStation::getPersonId, getUserInfo().getUserId());
		List<JpPersonStation> pPersonStation = pPersonStationMapper.selectList(qug);

		if (!pPersonStation.isEmpty()) {
			Page<TdHygfJpInverterWarnDto> page = new Page<TdHygfJpInverterWarnDto>();
			page.setCurrent(current);
			page.setSize(size);
			List<String> ids = pPersonStation.stream().map(i -> i.getStationId()).collect(Collectors.toList());
			tdHygfJpInverterWarnDto.setStationIds(ids);
			return ResponseHelper.buildResponse(
					tdHygfJpInverterWarnServiceImpl.queryForTdHygfJpInverterWarnPage(page, tdHygfJpInverterWarnDto));
		} else {
			return ResponseHelper.buildResponse(new Page<TdHygfJpInverterWarnDto>());
		}

	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘逆变器报警表列表全部数据查询", notes = "户用光伏监盘逆变器报警表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<TdHygfJpInverterWarnDto>> selectForList() {
		return ResponseHelper.buildResponse(tdHygfJpInverterWarnServiceImpl.queryForTdHygfJpInverterWarnList());
	}

     /**
      * 获取告警统计
      * **/
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "户用光伏监盘逆变器报警表列表全部数据查询", notes = "户用光伏监盘逆变器报警表列表全部数据查询")
    @GetMapping(value = "/selectcount")
    public ResponseModel<  Map<String,Object>  > selectcount(JpStationDto reviewDto) {
        LambdaQueryWrapper<JpStation> qugda=new LambdaQueryWrapper<>();
        //获取当前人管理场站
        if(reviewDto.getThirdStationId()==null){
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
            List<JpPersonStation> pPersonStation=pPersonStationMapper.selectList(qug);

            if(pPersonStation==null||pPersonStation.isEmpty()){
                return  ResponseHelper.buildResponse(null);
            }


            List ids=null;
            if(pPersonStation!=null&&!pPersonStation.isEmpty()){
                ids=new ArrayList();
                for (JpPersonStation jpPersonStation : pPersonStation) {
                    ids.add(jpPersonStation.getStationId());
                }
                qugda.in(ids!=null,JpStation::getThirdStationId,ids);
            }
        }else{
            qugda.eq(JpStation::getThirdStationId,reviewDto.getThirdStationId());
        }
        qugda.like(reviewDto.getUserName()!=null,JpStation::getUserName,reviewDto.getUserName());
        qugda.like(reviewDto.getArea()!=null,JpStation::getArea,reviewDto.getArea());
        List<JpStation> pPersonStation=jpStationMapper.selectList(qugda);
        List<Map<String,Object>>   datalist=    tdHygfJpInverterWarnMapper.getCountTdHygfJpInverterWarn(pPersonStation!=null&&!pPersonStation.isEmpty()?pPersonStation:null);
        Map<String,Object>  collector =new HashMap<>();
        collector.put("wcl",0);
        collector.put("ycl",0);

        if(datalist!=null&&!datalist.isEmpty()){
            for (Map<String, Object> map  : datalist) {
                if("未处理".equals(map.get("state").toString())){
                    collector.put("wcl",Integer.valueOf(map.get("num").toString()));
                }else if("已处理".equals(map.get("state").toString())||"已恢复".equals(map.get("state").toString())){
                    collector.put("ycl",Integer.valueOf(map.get("num").toString()));
                }
            }
        }
        return ResponseHelper.buildResponse(collector);
    }
}
