package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.hygf.api.entity.*;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.AllPowerMapper;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.MonthPowerMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IMonthPowerService;
import com.yeejoin.amos.boot.module.hygf.api.dto.MonthPowerDto;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.YearPowerMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * 按月统计服务实现类
 *
 * @author system_generator
 * @date 2023-09-20
 */
@Service
public class MonthPowerServiceImpl extends BaseService<MonthPowerDto,MonthPower,MonthPowerMapper> implements IMonthPowerService {

    @Autowired
    MonthPowerMapper monthPowerMapper;
    @Autowired
    YearPowerServiceImpl yearPowerServiceImpl;
    @Autowired
    AllPowerServiceImpl allPowerServiceImpl;
    @Autowired
    YearPowerMapper YearPowerMapper;

    /**
     * 分页查询
     */
    public Page<MonthPowerDto> queryForMonthPowerPage(Page<MonthPowerDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<MonthPowerDto> queryForMonthPowerList()   {
        return this.queryForList("" , false);
    }


    @Override
    @Transactional
    public void getMonthPower() {
        List<MonthPower> list= monthPowerMapper.getMonthPowerint();
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatterday = DateTimeFormatter.ofPattern("YYYY-MM-dd");
        String formattedDateday = now.format(formatterday);
        LambdaQueryWrapper<MonthPower> wrapperday = new LambdaQueryWrapper<>();
        wrapperday.eq(MonthPower::getDay, formattedDateday);
        List<MonthPower> listdday=  this.list(wrapperday);
        if(listdday!=null&&!listdday.isEmpty()){
            for (MonthPower monthPower : list) {
                for (MonthPower power : listdday) {
                    if(monthPower.getThirdStationId().equals(power.getThirdStationId())){
                        power.setCreatedTime(monthPower.getCreatedTime());
                    }else{

                    }
                }
            }
            this.saveBatch(list);
        }else{
            this.saveBatch(list);
        }

        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("YYYY-MM");
        String formattedDate = now.format(formatter);
        List<YearPower> listd=   monthPowerMapper.getSumMonthPower(formattedDate);


        LambdaQueryWrapper<YearPower> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(YearPower::getMonth, formattedDate);
        List<YearPower> listdY=  yearPowerServiceImpl.list(wrapper);
         if(listdY!=null&&!listdY.isEmpty()){
             for (YearPower yearPower : listd) {
                 for (YearPower power : listdY) {
                     if(yearPower.getThirdStationId()!=null&&yearPower.getThirdStationId().equals(power.getThirdStationId())){
                         //yearPower.setPower(power.getPower());
                         yearPower.setCreatedTime(power.getCreatedTime());
                     }
                 }
             }
             yearPowerServiceImpl.saveBatch(listd);
         }else{
             yearPowerServiceImpl.saveBatch(listd);
         }

        DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("YYYY");
        String formattedDate1 = now.format(formatter1);
        List<AllPower> listdy=   monthPowerMapper.getSumYearPower(formattedDate1);

        LambdaQueryWrapper<AllPower> wrapper1 = new LambdaQueryWrapper<>();
        wrapper1.eq(AllPower::getYear, formattedDate1);
        List<AllPower> listdall=  allPowerServiceImpl.list(wrapper1);
        if(listdall!=null&&!listdall.isEmpty()){
            for (AllPower yearPower : listdy) {
                for (AllPower power : listdall) {
                    if(yearPower.getThirdStationId()!=null&&yearPower.getThirdStationId().equals(power.getThirdStationId())){
                       // yearPower.setPower(power.getPower());
                        yearPower.setCreatedTime(power.getCreatedTime());
                    }
                }
            }
            allPowerServiceImpl.saveBatch(listdy);
        }else{
            allPowerServiceImpl.saveBatch(listdy);
        }

    }




}