package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizFanWarningRecordDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanWarningRecord;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanWarningRuleSet;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.IdxBizFanWarningRecordServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.IdxBizFanWarningRuleSetServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.beanutils.BeanMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 *
 * @author system_generator
 * @date 2023-08-15
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/idx-biz-fan-warning-record")
public class IdxBizFanWarningRecordController extends BaseController {

    @Autowired
    IdxBizFanWarningRecordServiceImpl idxBizFanWarningRecordServiceImpl;

    @Autowired
	IdxBizFanWarningRuleSetServiceImpl idxBizFanWarningRuleSetService;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<IdxBizFanWarningRecordDto> save(@RequestBody IdxBizFanWarningRecordDto model) {
	    model = idxBizFanWarningRecordServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<IdxBizFanWarningRecordDto> updateBySequenceNbrIdxBizFanWarningRecord(@RequestBody IdxBizFanWarningRecordDto model,@PathVariable(value = "sequenceNbr") String sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(idxBizFanWarningRecordServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(idxBizFanWarningRecordServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<IdxBizFanWarningRecordDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(idxBizFanWarningRecordServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<IdxBizFanWarningRecordDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<IdxBizFanWarningRecordDto> page = new Page<IdxBizFanWarningRecordDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(idxBizFanWarningRecordServiceImpl.queryForIdxBizFanWarningRecordPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<IdxBizFanWarningRecordDto>> selectForList() {
	    return ResponseHelper.buildResponse(idxBizFanWarningRecordServiceImpl.queryForIdxBizFanWarningRecordList());
	}


	/**
	 * 根据sequenceNbr查询
	 *
	 * @param ANALYSISPOINTID  主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getInfoByPointId")
	@ApiOperation(httpMethod = "GET",value = "根据ANALYSIS_POINT_ID查询单个",  notes = "根据ANALYSIS_POINT_ID查询单个")
	public ResponseModel<Map<String, Object>> getInfoByPointId(@RequestParam String ANALYSISPOINTID) {

		LambdaQueryWrapper<IdxBizFanWarningRuleSet>	query  =new LambdaQueryWrapper<>();
		query.eq(IdxBizFanWarningRuleSet::getAnalysisPointId,ANALYSISPOINTID);
		List<IdxBizFanWarningRuleSet> idxBizFanWarningRecordList = idxBizFanWarningRuleSetService.getBaseMapper().selectList(query);
		Map<String,Object> map = new HashMap<>();
		for (int i = 0; i < idxBizFanWarningRecordList.size(); i++) {
			IdxBizFanWarningRuleSet idxBizFanWarningRecord = idxBizFanWarningRecordList.get(i);
			if (idxBizFanWarningRecord.getWarningName().equals("注意")){
				map.putAll(BeanUtil.beanToMap(idxBizFanWarningRecord));
			}else if (idxBizFanWarningRecord.getWarningName().equals("警告")){
				//警告周期
				map.put("jgWarningCycle",idxBizFanWarningRecord.getWarningCycle());
				map.put("jgWarningIf",idxBizFanWarningRecord.getWarningIf());
			}else if (idxBizFanWarningRecord.getWarningName().equals("危险")){
				//警告周期
				map.put("wxWarningCycle",idxBizFanWarningRecord.getWarningCycle());
				map.put("wxWarningIf",idxBizFanWarningRecord.getWarningIf());
			}
		}
		return ResponseHelper.buildResponse(map);
	}



	/**
	 * 根据pointId修改信息
	 *
	 * @param analysisInfo  主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/updateByPointInfo")
	@ApiOperation(httpMethod = "POST", value = "根据pointId修改信息", notes = "根据pointId修改信息")
	public ResponseModel<Boolean> updateByPointInfo(@RequestBody JSONObject analysisInfo) {
		LambdaQueryWrapper<IdxBizFanWarningRuleSet> query = new LambdaQueryWrapper<>();
		query.eq(IdxBizFanWarningRuleSet::getAnalysisPointId, analysisInfo.get("analysisPointId"));
		List<IdxBizFanWarningRuleSet> idxBizFanWarningRecordList = idxBizFanWarningRuleSetService.getBaseMapper().selectList(query);
		for (IdxBizFanWarningRuleSet idxBizFanWarningRuleSet : idxBizFanWarningRecordList) {
			BeanUtil.copyProperties(analysisInfo, idxBizFanWarningRuleSet, "sequenceNbr", "warningName");
			if (idxBizFanWarningRuleSet.getWarningName().equals("警告")) {
				//警告周期
				idxBizFanWarningRuleSet.setWarningIf(analysisInfo.get("jgWarningIf").toString());
				idxBizFanWarningRuleSet.setWarningCycle(analysisInfo.get("jgWarningCycle").toString());
			} else if (idxBizFanWarningRuleSet.getWarningName().equals("危险")) {
				//警告周期
				idxBizFanWarningRuleSet.setWarningIf(analysisInfo.get("wxWarningIf").toString());
				idxBizFanWarningRuleSet.setWarningCycle(analysisInfo.get("wxWarningCycle").toString());
			}
		}
		boolean b = idxBizFanWarningRuleSetService.updateBatchById(idxBizFanWarningRecordList);
		return ResponseHelper.buildResponse(b);
	}
}
