package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizPvHealthIndexDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizPvWarningRecord;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.IdxBizPvHealthIndexServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 *
 * @author system_generator
 * @date 2023-08-15
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/idx-biz-pv-health-index")
public class IdxBizPvHealthIndexController extends BaseController {

    @Autowired
    IdxBizPvHealthIndexServiceImpl idxBizPvHealthIndexServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<IdxBizPvHealthIndexDto> save(@RequestBody IdxBizPvHealthIndexDto model) {
	    model = idxBizPvHealthIndexServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<IdxBizPvHealthIndexDto> updateBySequenceNbrIdxBizPvHealthIndex(@RequestBody IdxBizPvHealthIndexDto model,@PathVariable(value = "sequenceNbr") String sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(idxBizPvHealthIndexServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(idxBizPvHealthIndexServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<IdxBizPvHealthIndexDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(idxBizPvHealthIndexServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<IdxBizPvHealthIndexDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<IdxBizPvHealthIndexDto> page = new Page<IdxBizPvHealthIndexDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(idxBizPvHealthIndexServiceImpl.queryForIdxBizPvHealthIndexPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<IdxBizPvHealthIndexDto>> selectForList() {
	    return ResponseHelper.buildResponse(idxBizPvHealthIndexServiceImpl.queryForIdxBizPvHealthIndexList());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "预警监测设备级左侧列表",   notes = "预警监测设备级左侧列表")
	@GetMapping(value = "/queryForLeftTableListByEquip")
	public ResponseModel<Page<Map<String,Object>>> queryForLeftTableListByEquip(@RequestParam(required = false) String STATION, @RequestParam(required = false) String SUBARRAY, @RequestParam(required = false) String HEALTHLEVEL, @RequestParam(required = false) String EQUIPMENTNAME, @RequestParam(required = false) Integer current, @RequestParam(required = false) Integer size ) {
		Page<Map<String,Object>> page = new Page<Map<String,Object>>();
		page.setCurrent(current);
		page.setSize(size);
		int total = idxBizPvHealthIndexServiceImpl.queryForLeftTableListByEquipCount(STATION, SUBARRAY, HEALTHLEVEL,EQUIPMENTNAME);
		Long num = Long.valueOf(total);
		page.setTotal(num);
		page.setRecords(idxBizPvHealthIndexServiceImpl.queryForLeftTableListByEquip(STATION,SUBARRAY,HEALTHLEVEL,EQUIPMENTNAME,(current-1)*size,size));
		return ResponseHelper.buildResponse(page);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "预警监测测点级左侧列表",   notes = "预警监测设备级左侧列表")
	@GetMapping(value = "/queryForLeftTableListByPoint")
	public ResponseModel<Page<Map<String,Object>>> queryForLeftTableListByPoint(@RequestParam(required = false) String STATION,@RequestParam(required = false) String SUBARRAY,@RequestParam(required = false) String HEALTHLEVEL,@RequestParam(required = false) String EQUIPMENTNAME,@RequestParam(required = false) String POINTNAME,@RequestParam(required = false) Integer current,@RequestParam(required = false) Integer size) {
		Page<Map<String,Object>> page = new Page<Map<String,Object>>();
		page.setCurrent(current);
		page.setSize(size);
		int total = idxBizPvHealthIndexServiceImpl.queryForLeftTableListByPointCount(STATION, SUBARRAY, HEALTHLEVEL, EQUIPMENTNAME, POINTNAME);
		Long num = Long.valueOf(total);
		page.setTotal(num);
		page.setRecords(idxBizPvHealthIndexServiceImpl.queryForLeftTableListByPoint(STATION,SUBARRAY,HEALTHLEVEL,EQUIPMENTNAME,POINTNAME,(current-1)*size,size));
		return ResponseHelper.buildResponse(page);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "预警监测设备级仪表盘",   notes = "预警监测设备级仪表盘")
	@GetMapping(value = "/queryForLeftTableListByEquipNum")
	public ResponseModel<Map<String,Object>> queryForLeftTableListByEquipNum(@RequestParam(required = false) String STATION, @RequestParam(required = false) String SUBARRAY, @RequestParam(required = false) String HEALTHLEVEL, @RequestParam(required = false) String EQUIPMENTNAME) {

	;
			return ResponseHelper.buildResponse(idxBizPvHealthIndexServiceImpl.queryForLeftTableListByEquipNum(STATION, SUBARRAY, HEALTHLEVEL,EQUIPMENTNAME));
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "预警监测测点级仪表盘",   notes = "预警监测设备级仪表盘")
	@GetMapping(value = "/queryForLeftTableListByPointNum")
	public ResponseModel<Map<String,Object>> queryForLeftTableListByPointNum(@RequestParam(required = false) String STATION,@RequestParam(required = false) String SUBARRAY,@RequestParam(required = false) String HEALTHLEVEL,@RequestParam(required = false) String EQUIPMENTNAME,@RequestParam(required = false) String POINTNAME) {

		return ResponseHelper.buildResponse(idxBizPvHealthIndexServiceImpl.queryForLeftTableListByPointNum(STATION, SUBARRAY, HEALTHLEVEL, EQUIPMENTNAME, POINTNAME));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "预警监测设备级统计",   notes = "预警监测设备级统计")
	@GetMapping(value = "/queryForPointNum")
	public ResponseModel<List<Map<String,Object>>> queryForLeftTableListByPointNum(@RequestParam(required = false) String STATION,@RequestParam(required = false) String SUBARRAY,@RequestParam(required = false) String  EQUIPMENTNAME) {
		List<IdxBizPvWarningRecord> idxBizPvWarningRecordList = idxBizPvHealthIndexServiceImpl.warningData(STATION, SUBARRAY, EQUIPMENTNAME);
		int total = idxBizPvHealthIndexServiceImpl.pointNum(STATION, SUBARRAY, EQUIPMENTNAME);

		Map<String,Object> map =new HashMap<>();
		Map<String,Object> map1 =new HashMap<>();
		Map<String,Object> warningNum =new HashMap<>();
		warningNum.put("name","注意");
		warningNum.put("value",idxBizPvWarningRecordList.stream().filter(e->e.getWarningName().equals("注意")).count());

		map.put("name","警告");
		map.put("value",idxBizPvWarningRecordList.stream().filter(e->e.getWarningName().equals("警告")).count());

		map1.put("name","危险");
		map1.put("value",idxBizPvWarningRecordList.stream().filter(e->e.getWarningName().equals("危险")).count());

		Map<String,Object> pointNum =new  HashMap<>();
		pointNum.put("name","正常");
		pointNum.put("value",total  - idxBizPvWarningRecordList.size());

		List<Map<String,Object>> list = new ArrayList<>();
		list.add(pointNum);
		list.add(warningNum);
		list.add(map1);
		list.add(map);

		return ResponseHelper.buildResponse(list);
	}
}
